% Generated by roxygen2: do not edit by hand
% Please edit documentation in
%   R/step4SelectMostSignificantLinksPerDNAMethylationSite.R
\name{step4SelectMostSignificantLinksPerDNAMethylationSite}
\alias{step4SelectMostSignificantLinksPerDNAMethylationSite}
\title{Select the most significant RE DNA methylation site-gene links to each RE DNA
methylation site}
\usage{
step4SelectMostSignificantLinksPerDNAMethylationSite(
  TENETMultiAssayExperiment,
  hypermethGplusAnalysis = TRUE,
  hypomethGplusAnalysis = TRUE,
  linksPerREDNAMethylationSiteMaximum = 25,
  multipleTestingCorrectionMethod = NA,
  multipleTestingPValue = 0.05,
  coreCount = 1
)
}
\arguments{
\item{TENETMultiAssayExperiment}{Specify a MultiAssayExperiment object
containing expression and methylation SummarizedExperiment objects, such as
one created by the TCGADownloader function. The object's metadata must
contain the results from the \code{step2GetDifferentiallyMethylatedSites} and
\code{step3GetAnalysisZScores} functions.}

\item{hypermethGplusAnalysis}{Set to TRUE to analyze hypermethylated G+ RE
DNA methylation site-gene links. Requires the hypermethAnalysis parameter to
have been set to TRUE in step 3.}

\item{hypomethGplusAnalysis}{Set to TRUE to analyze hypomethylated G+ RE DNA
methylation site-gene links. Requires the hypomethAnalysis parameter to have
been set to TRUE in step 3.}

\item{linksPerREDNAMethylationSiteMaximum}{This parameter must either be set
to an integer n greater than 0, in which case only the n most significant RE
DNA methylation site-gene link pairs from step 3 will be selected per unique
RE DNA methylation site, or NA if using the multipleTestingPValue argument to
set a significant p-value cutoff. Defaults to 25.}

\item{multipleTestingCorrectionMethod}{Specify a character string describing
a multiple testing correction method supported by \code{p.adjust} (see
\code{?stats::p.adjust}) to perform multiple testing correction on the Z-scores
from step 3, using the \code{multipleTestingPValue} argument to specify the
significant p-value cutoff, or specify NA to skip multiple testing
correction, in which case \code{linksPerREDNAMethylationSiteMaximum} will be used
to determine the number of links to retain. If specified,
\code{linksPerREDNAMethylationSiteMaximum} will be ignored. Defaults to NA.}

\item{multipleTestingPValue}{Cutoff for multiple testing corrected p-values.
This argument is only used if the \code{multipleTestingCorrectionMethod} argument
is specified. Defaults to 0.05.}

\item{coreCount}{Argument passed as the mc.cores argument to mclapply. See
\code{?parallel::mclapply} for more details. Defaults to 1.}
}
\value{
Returns the MultiAssayExperiment object given as the
TENETMultiAssayExperiment argument with an additional list named
"step4SelectMostSignificantLinksPerDNAMethylationSite" in its metadata
containing the most significant selected gene links to the hyper- and/or
hypomethylated RE DNA methylation sites.
}
\description{
This function takes the calculated Z-scores for the hyper- and/or
hypomethylated G+ RE DNA methylation site-gene links and selects the most
significant links to each RE DNA methylation site, either up to a number
specified by the user, or based on a significant p-value level set by the
user after multiple testing correction is performed on the Z-scores output
by the \code{step3GetAnalysisZScores} function per RE DNA methylation site in the
RE DNA methylation site-gene pairs.
}
\examples{
\dontshow{if (interactive()) withAutoprint(\{ # examplesIf}
## This example uses the example MultiAssayExperiment provided in the
## TENET.ExperimentHub package to identify the 25 most significant links
## between both hyper- and hypomethylated enhancer DNA methylation sites and
## all genes, using one CPU core to perform the analysis.

## Load the example TENET MultiAssayExperiment object
## from the TENET.ExperimentHub package
exampleTENETMultiAssayExperiment <-
    TENET.ExperimentHub::exampleTENETMultiAssayExperiment()

## Perform the analysis
returnValue <- step4SelectMostSignificantLinksPerDNAMethylationSite(
    TENETMultiAssayExperiment = exampleTENETMultiAssayExperiment
)

## This example demonstrates many of the analysis options. It identifies
## the most significant links between only hypomethylated enhancer DNA
## methylation sites and all genes by performing Bonferroni multiple testing
## correction using a significant p-value of 0.10, using 8 CPU cores to
## perform the analysis. Note: Running this code with the
## exampleTENETMultiAssayExperiment will produce a warning message because
## sparseResults was set to TRUE when the example dataset was generated, but
## it is still valid as an example.

## Load the example TENET MultiAssayExperiment object
## from the TENET.ExperimentHub package
exampleTENETMultiAssayExperiment <-
    TENET.ExperimentHub::exampleTENETMultiAssayExperiment()

## Perform the analysis
returnValue <- step4SelectMostSignificantLinksPerDNAMethylationSite(
    TENETMultiAssayExperiment = exampleTENETMultiAssayExperiment,
    hypermethGplusAnalysis = FALSE,
    multipleTestingCorrectionMethod = "bonferroni",
    multipleTestingPValue = 0.1,
    coreCount = 8
)
\dontshow{\}) # examplesIf}
}
