% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/step3GetAnalysisZScores.R
\name{step3GetAnalysisZScores}
\alias{step3GetAnalysisZScores}
\title{Calculate Z-scores comparing the mean expression of each gene in the case
samples that are hyper- and/or hypomethylated for each RE DNA methylation
site identified in step 2}
\usage{
step3GetAnalysisZScores(
  TENETMultiAssayExperiment,
  hypermethAnalysis = TRUE,
  hypomethAnalysis = TRUE,
  includeControl = FALSE,
  TFOnly = TRUE,
  zScoreCalculation = "oneSample",
  sparseResults = TRUE,
  pValue = 0.05,
  coreCount = 1
)
}
\arguments{
\item{TENETMultiAssayExperiment}{Specify a MultiAssayExperiment object
containing expression and methylation SummarizedExperiment objects,
such as one created by the TCGADownloader function. The object's metadata
must contain the results from the \code{step2GetDifferentiallyMethylatedSites}
function.}

\item{hypermethAnalysis}{Set to TRUE to calculate Z-scores for
hypermethylated RE DNA methylation sites. Defaults to TRUE.}

\item{hypomethAnalysis}{Set to TRUE to calculate Z-scores for
hypomethylated RE DNA methylation sites. Defaults to TRUE.}

\item{includeControl}{Set to TRUE to include the control samples when
identifying hyper/hypomethylated groups and calculating Z-scores.
Defaults to FALSE.}

\item{TFOnly}{Set to TRUE to only consider genes that are accepted
transcription factors according to "The Human Transcription Factors" by
Lambert et al. 2018 when calculating Z-scores. Defaults to TRUE.}

\item{zScoreCalculation}{Set to 'oneSample' to use a one-sample Z-score
calculation or 'twoSample' to use a two sample Z-score calculation. Note
that 'twoSample' tends to be much more lenient, and identifies many more
significant RE DNA methylation site-gene links. Defaults to 'oneSample'.}

\item{sparseResults}{Set to TRUE to save only the significant Z-scores
for RE DNA methylation site-gene links. \strong{Note:} If multiple testing
correction will be performed in the subsequent
\code{step4SelectMostSignificantLinksPerDNAMethylationSite} function, this
argument should be set to FALSE. Defaults to TRUE.}

\item{pValue}{Specify the p-value below which Z-scores will be considered
significant during comparison of gene expression values between case samples
that are hyper- or hypomethylated and those that are not. If \code{sparseResults}
is set to TRUE, only significant Z-scores will be saved in the output
MultiAssayExperiment object. Defaults to 0.05.}

\item{coreCount}{Argument passed as the mc.cores argument to
mclapply. See \code{?parallel::mclapply} for more details. Defaults to 1.}
}
\value{
Returns the MultiAssayExperiment object given as the
TENETMultiAssayExperiment argument with an additional list
named "step3GetAnalysisZScores" in its metadata containing the output
of this function, which includes Z-scores comparing the mean expression of
each gene in samples that are hypo- and/or hypomethylated for each RE DNA
methylation site with the mean expression in samples that are not.
}
\description{
This function calculates Z-scores comparing the mean expression of each gene
in the case samples that are hyper- and/or hypomethylated for each RE DNA
methylation site identified in step 2, according to the methylation cutoffs
set in step 2, to the mean expression of the remaining non-hyper- or
hypomethylated case samples. By identifying significant Z-scores, initial
RE DNA methylation site-gene links are identified, in the form of case
samples with hyper- or hypomethylation of a particular RE DNA methylation
site also displaying particularly high or low expression of specific genes.
}
\examples{
\dontshow{if (interactive()) withAutoprint(\{ # examplesIf}
## This example uses the example MultiAssayExperiment provided in the
## TENET.ExperimentHub package to calculate one-sample Z-scores for links
## between both hypermethylated and hypomethylated RE DNA methylation
## sites and the expression of transcription factor genes only, considering
## only case samples. Only significant Z-scores (based on a threshold of
## p<0.05) will be saved to the TENETMultiAssayExperiment object. The
## analysis will be performed using one CPU core.

## Load the example TENET MultiAssayExperiment object
## from the TENET.ExperimentHub package
exampleTENETMultiAssayExperiment <-
    TENET.ExperimentHub::exampleTENETMultiAssayExperiment()

## Calculate Z-scores for hyper- and hypomethylated RE DNA methylation sites
returnValue <- step3GetAnalysisZScores(
    TENETMultiAssayExperiment = exampleTENETMultiAssayExperiment
)

## This example demonstrates many of the analysis options. It calculates
## two-sample Z-scores for links between only hypomethylated RE DNA
## methylation sites and all genes, considering both case and control samples
## All Z-scores will be saved to the TENETMultiAssayExperiment object
## (which takes a large amount of memory). Z-scores with p-values less
## than 0.1 will be considered significant. The analysis will be performed
## using 8 CPU cores.

## Load the example TENET MultiAssayExperiment object
## from the TENET.ExperimentHub package
exampleTENETMultiAssayExperiment <-
    TENET.ExperimentHub::exampleTENETMultiAssayExperiment()

## Calculate Z-scores for only hypomethylated RE DNA methylation sites
returnValue <- step3GetAnalysisZScores(
    TENETMultiAssayExperiment = exampleTENETMultiAssayExperiment,
    hypermethAnalysis = FALSE,
    includeControl = TRUE,
    TFOnly = FALSE,
    zScoreCalculation = "twoSample",
    sparseResults = FALSE,
    pValue = 0.1,
    coreCount = 8
)
\dontshow{\}) # examplesIf}
}
