% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prepareCondTCGA.R
\name{prepareCondTCGA}
\alias{prepareCondTCGA}
\title{Prepare Sample label for TCGA data}
\usage{
prepareCondTCGA(
  Multi_sample,
  Clinical,
  ID_column_of_Multi_sample,
  ID_column_of_Clinical
)
}
\arguments{
\item{Multi_sample}{list of sample ids}

\item{Clinical}{List of clinical data matrix from RTCGA.clinical}

\item{ID_column_of_Multi_sample}{Column numbers used for conditions}

\item{ID_column_of_Clinical}{Column numbers that include corresponding
sample ids in clinical data}
}
\value{
list of sample labels
}
\description{
Prepare Sample label for TCGA data
}
\examples{
library(RTCGA.clinical)
library(RTCGA.rnaseq)
Clinical <- list(BLCA.clinical, BRCA.clinical, CESC.clinical, COAD.clinical)
Multi_sample <- list(
  BLCA.rnaseq[seq_len(100), 1, drop = FALSE],
  BRCA.rnaseq[seq_len(100), 1, drop = FALSE],
  CESC.rnaseq[seq_len(100), 1, drop = FALSE],
  COAD.rnaseq[seq_len(100), 1, drop = FALSE]
)
ID_column_of_Multi_sample <- c(770, 1482, 773, 791)
ID_column_of_Clinical <- c(20, 20, 12, 14)
cond <- prepareCondTCGA(
  Multi_sample, Clinical,
  ID_column_of_Multi_sample, ID_column_of_Clinical
)
}
