% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots.R
\name{timeclustplot}
\alias{timeclustplot}
\title{Plot clustering results for time course data.}
\usage{
timeclustplot(
  object = NULL,
  categories = "timepoint",
  value = "expression",
  cols = NULL,
  cl.color = "gray50",
  membership.color = rainbow(30, s = 3/4, v = 1, start = 1/6),
  title.size = 18,
  axis.line.size = 0.6,
  axis.title.size = 18,
  axis.text.size = 16,
  legend.title.size = 14,
  legend.text.size = 14
)
}
\arguments{
\item{object}{a \code{TCA} object or a \code{clust} object}

\item{categories}{character string giving the x-axis label}

\item{value}{character string giving the y-axis label}

\item{cols}{integer value specifying number of columns in the final
layout.}

\item{cl.color}{character string specifying a color for hard
clustering.}

\item{membership.color}{color palettes, a character vector of
n colors}

\item{title.size}{numeric value specifying the font size of title
of each
plot in the layout}

\item{axis.line.size}{numeric value specifying the size of both
axis lines}

\item{axis.title.size}{numeric value specifying the font size of
titles of both axis}

\item{axis.text.size}{numeric value specifying the font size of
labels of both axis}

\item{legend.title.size}{numeric value specifying the font size
of legend title}

\item{legend.text.size}{numeric value specifying the font size of
legend text}
}
\value{
Plot all clusters in one plot and return a list of ggplot objects,
each object is for one cluster. The ggplot object can be drawed by
calling \code{\link{print.ggplot}}
}
\description{
This function plots the clusters generated from
\code{\link{timeclust}}. For fuzzy cmeans clustering, data points
are color-coded according to membership values, the color palettes
can be customized.
}
\examples{
x <- matrix(sample(500, 1600, replace = TRUE), nrow = 200,
            dimnames = list(paste0('peak', 1:200), 1:8))
clust_res <- timeclust(x, algo = 'cm', k = 4, standardize = TRUE)
p <- timeclustplot(clust_res, cols =2)
# to plot a individual cluster
print (p[[2]]) # plot cluster 2
print (p[[3]]) # plot cluster 3

}
\author{
Mengjun Wu
}
