% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TCGAbarcode.R
\name{TCGAbarcode}
\alias{TCGAbarcode}
\title{Parse data from TCGA barcode}
\usage{
TCGAbarcode(
  barcodes,
  participant = TRUE,
  sample = FALSE,
  portion = FALSE,
  plate = FALSE,
  center = FALSE,
  index = NULL
)
}
\arguments{
\item{barcodes}{A character vector of TCGA barcodes}

\item{participant}{Logical (default TRUE) participant identifier chunk}

\item{sample}{Logical (default FALSE) includes the numeric sample code of
the barcode and the vial letter}

\item{portion}{Logical (default FALSE) includes the portion and analyte
codes of the barcode}

\item{plate}{Logical (default FALSE) returns the plate value}

\item{center}{Logical (default FALSE) returns a matrix with the plate and
center codes}

\item{index}{An optional numeric vector indicating barcode positions when
split by the delimiter (i.e., hyphen '-'). For example, an index of
\code{c(1, 2)} corresponds to 'TCGA-ZZ' in \code{TCGA-ZZ-A1A1}.}
}
\value{
A character vector or data matrix of TCGA barcode information
}
\description{
This function returns the specified snippet of information obtained from
the TCGA barcode.
}
\examples{
barcodes <- c("TCGA-B0-5117-11A-01D-1421-08",
"TCGA-B0-5094-11A-01D-1421-08",
"TCGA-E9-A295-10A-01D-A16D-09")

## Patient identifiers
TCGAbarcode(barcodes)

## Sample identifiers
TCGAbarcode(barcodes, sample = TRUE)

}
\author{
M. Ramos
}
