% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simplifyColData.R
\name{mergeColData}
\alias{mergeColData}
\title{Take a MultiAssayExperiment and include curated variables}
\usage{
mergeColData(MultiAssayExperiment, colData)
}
\arguments{
\item{MultiAssayExperiment}{A
\code{\link[MultiAssayExperiment:MultiAssayExperiment-class]{MultiAssayExperiment}}
object}

\item{colData}{A \code{DataFrame} or \code{data.frame} to merge with
clinical data in the \code{MultiAssayExperiment} object}
}
\value{
A
\code{\link[MultiAssayExperiment:MultiAssayExperiment-class]{MultiAssayExperiment}}
object
}
\description{
This function works on the \code{colData} of a
\code{\link[MultiAssayExperiment:MultiAssayExperiment-class]{MultiAssayExperiment}}
object to merge curated variable columns or other clinical variables that
would like to be added. It is recommended that the user run the scripts in
the \code{MultiAssayExperiment.TCGA} repository that build the "enhanced" type of
data but not necessary if using different clinical data. Please see the
repository's README for more information.
}
\examples{

library(MultiAssayExperiment)

mergeColData(MultiAssayExperiment(), S4Vectors::DataFrame())

}
