% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getFileName.R
\name{getFileName}
\alias{getFileName}
\title{Find the file names used in RTCGAToolbox}
\usage{
getFileName(
  disease,
  runDate = "20160128",
  dataType = c("CNASNP", "CNVSNP", "CNAseq", "CNACGH", "Mutation")
)
}
\arguments{
\item{disease}{The TCGA cancer disease code, e.g., "COAD"}

\item{runDate}{The single \code{string} used in the \code{getFirehoseData}
function (default "20160128")}

\item{dataType}{A single character vector (default "CNASNP") indicating the
data type for which to get the source file name}
}
\value{
A single \code{character} file name
}
\description{
Part of this function is from the RTCGAToolbox. It aims to extract the file
name used inside of the \link[RTCGAToolbox]{getFirehoseData} function.
The arguments of the function parallel those in the
\link[RTCGAToolbox]{getFirehoseData} function. It is only available for
select data types.
}
\examples{

getFileName("COAD", dataType = "CNASNP")

}
