% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/regioned_dna_Class.R
\name{get_freq}
\alias{get_freq}
\alias{get_freq,regioned_dna-method}
\alias{get_freq,DNAStringSet-method}
\alias{get_freq,matrix-method}
\alias{get_freq,vector-method}
\title{Get codon usage frequency of synonymous codons}
\usage{
get_freq(object, numcode = 1, ...)

\S4method{get_freq}{regioned_dna}(object, numcode)

\S4method{get_freq}{DNAStringSet}(object, numcode)

\S4method{get_freq}{matrix}(object, numcode)

\S4method{get_freq}{vector}(object, numcode)
}
\arguments{
\item{object}{regioned_dna / DNAStringSet / codon usage matrix (vector)}

\item{numcode}{The ncbi genetic code number for translation. Default value: \code{1}. Details please refer to \code{?seqinr::translate} ("https://rdrr.io/cran/seqinr/man/translate.html").}

\item{...}{...}
}
\value{
matrix
}
\description{
Access the synonymous codon usage frequency
}
\examples{
filepath <- system.file("extdata", "example.fasta", package = "SynMut")
rgd.seq <- input_seq(filepath)
get_freq(rgd.seq)
}
\seealso{
\code{\link{input_seq}}, \code{\link{get_region}},
  \code{\link{get_cu}}, \code{\link{get_du}}, \code{\link{get_rscu}}
}
