\name{reliabilityCheckSwath}
\alias{reliabilityCheckSwath}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{
A function to check the coverage, fdr distrubtions, quantification accuary etc of two Swath results
}
\description{
%%  ~~ A concise (1-5 lines) description of what the function does. ~~
}
\usage{
reliabilityCheckSwath(seed.swathfile, ext.swathfile, max.fdrpass = 3, max.peptide = 2)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{seed.swathfile}{
A string representing the Swath results obtained using the seed library. The Swath result file should be a PeakView extracted
Excel (.xlsx) file with six tabs: "Area - ions", "Area - peptides", "Area - proteins", "Score", "FDR" and "Observed RT". 
The SWATH result checking functions require that worksheet ``Area - peptides" and ``FDR" must exist. 
}
  \item{ext.swathfile}{
A string representing the Swath results obtained using the extended library. The Swath result file should be a PeakView extracted
Excel (.xlsx) file with six tabs: ``Area - ions", ``Area - peptides", ``Area - proteins", ``Score", ``FDR" and ``Observed RT". 
The SWATH result checking functions require that worksheet ``Area - peptides" and ``FDR" must exist. 
}
  \item{max.fdrpass}{
A numeric value representing the maximum number of samples that pass the fdr threshold (0.01)
}
  \item{max.peptide}{
A numeric value representing the maximum number of peptides in a protein as a filter
}
}
\details{
%%  ~~ If necessary, more details than the description above ~~
}
\value{
 \item{fdr.bins }{a matrix of the FDR percentage in each of the 8 bins }
  \item{dat.comb }{a matrix of the various numbers as the SWATH filtering threshold changes. These numbers include protein, peptide,
	median correlation, cv and bland altman mesuarement. }
}
\references{
%% ~put references to the literature/web site here ~
}
\author{
%%  ~~who you are~~
}
\note{
%%  ~~further notes~~
}

%% ~Make other sections like Warning with \section{Warning }{....} ~

\seealso{
%% ~~objects to See Also as \code{\link{help}}, ~~~
}
\examples{
files <- paste(system.file("files",package="SwathXtend"), 
		c("Swath_result_Lib2.xlsx", "Swath_result_Lib2_3.xlsx"), sep="/")
res = reliabilityCheckSwath(files[1], files[2])
}
% Add one or more standard keywords, see file 'KEYWORDS' in the
% R documentation directory.
\keyword{ ~kwd1 }% use one of  RShowDoc("KEYWORDS")
\keyword{ ~kwd2 }% __ONLY ONE__ keyword per line
