\name{readLibFile}
\alias{readLibFile}
\title{Load a spectrum library into a data frame}
\usage{
readLibFile(file, format = c("peakview", "openswath"), type = c("spectrum",
  "hydro"), clean = TRUE, ...)
}
\arguments{
\item{file}{A file of a spectrum library, in .txt or .csv format, can be .gz files.}

\item{format}{A character string denoting the file format. One of "peakview" (default) and "openswath". If the file
	format is "peakview", it requires the following columns:

Q1: Q1 m/z (precursor m/z);
Q3: Q3 m/z (fragment m/z);
RT_detected: retention time;
protein_name: protein name;
isotype: isotype type;
relative_intensity: fragment ion intensity;
stripped_sequence: peptide sequences without modifications;
modification_sequence: peptide sequences with modifications;
prec_z: peptide charge;
frg_type: fragment type;
frg_z: fragment charge;
frg_nr: ion number;
iRT: calibrated retention time;
uniprot_id: database accession number;
decoy: whether the peptide a decoy or not;
confidence: the confidence of the identified peptide;
shared: whether the peptide is shared by multiple proteins;
N: a ranking number for the protein.

Optional columns for PeakView format libaries include:
score: score for peptide identification;
prec_y: the precursor ion intensity;
rank: ion intensity ranking;
mods: modification;
nterm: N terminal modification;
cterm: C terminal modification;

If the file format is "openswath", it must contain the following columns:
PrecursorMz: precursor m/z;
ProductMz: fragment m/z;
Tr_recalibrated: retention time;
ProteinName: protein name;
GroupLabel: isotype type;
LibraryIntensity: fragment ion intensity;
PeptideSequence: peptide sequences without modifications;
FullUniModPeptideName: peptide sequences with modifications;
UniprotID: database accession number;
decoy: whether the peptide a decoy or not
PrecursorCharge: precursor charge;
FragmentType: fragment type (b or y ion);
FragmentCharge: fragment charge;
FragmentSeriesNumber: fragment ion number.
 }

\item{type}{A character string denoting the file type. One of "spectrum" (default) and "hydro"}

\item{clean}{A logic value, representing if the library will be cleaned.}

  \item{\dots}{
	Additional parameters to pass in
}
}
\value{
a data frame of the library with cleaning process
}
\description{
Load a spectrum library into a data frame
}
\examples{
file <- paste(system.file("files",package="SwathXtend"),"Lib1.txt",sep="/")
dat <- readLibFile(file)
}

