\name{quantification.accuracy}
\alias{quantification.accuracy}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{
Measurment of quantification accuracy of two Swath results
}
\description{
%%  ~~ A concise (1-5 lines) description of what the function does. ~~
}
\usage{
quantification.accuracy(dswat1, dswat2, Sample = NULL, method = c("cor", "cv", "bland.altman"), 
cor.method=c('pearson', 'spearman', 'kendall'), log = FALSE)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{dswat1}{
	A data frame of peptide peak area of the first Swath result
}
  \item{dswat2}{
	A data frame of peptide peak area of the second Swath result
}
  \item{Sample}{
	A vector of strings representing the sample names of the Swath result
}
  \item{method}{
	A string as one of "cor", "cv" and "bland.altman"
}
 \item{cor.method}{
	A string as one of "pearson", "spearman", and "kendall"
}
\item{log}{
	A logical value indicating if the peak area will be log transformed before calculating the measurement. Default
	value is FALSE which means the peak area will not be transformed.
}
}
\details{
%%  ~~ If necessary, more details than the description above ~~
}
\value{
A list of two numeric vectors 
  \item{vcor }{The measurment for the quanitification accuarcy for the same sample}
 \item{rcor }{The measurment for the quanitification accuarcy for the randomised sample}
}
\references{
%% ~put references to the literature/web site here ~
}
\author{
%%  ~~who you are~~
}
\note{
%%  ~~further notes~~
}

%% ~Make other sections like Warning with \section{Warning }{....} ~

\seealso{
%% ~~objects to See Also as \code{\link{help}}, ~~~
}
\examples{

fswaths = paste(system.file("files",package="SwathXtend"),c("Swath_result_Lib2.xlsx", "Swath_result_Lib2_3.xlsx"), sep="/")

fdr.seed = readWorkbook(fswaths[1], sheet='FDR')
fdr.ext = readWorkbook(fswaths[2], sheet='FDR')
 
swa.seed = readWorkbook(fswaths[1], 2)
swa.ext = readWorkbook(fswaths[2], 2)

fdr.seed = fdr.crit(fdr.seed)
fdr.ext = fdr.crit(fdr.ext)

res = quantification.accuracy(swa.seed[fdr.seed$nfdr.pass >= 2,], swa.ext[fdr.ext$nfdr.pass >= 2,], method="cv")
								
}
% Add one or more standard keywords, see file 'KEYWORDS' in the
% R documentation directory.
\keyword{ ~kwd1 }% use one of  RShowDoc("KEYWORDS")
\keyword{ ~kwd2 }% __ONLY ONE__ keyword per line
