\name{cleanLib}
\alias{cleanLib}
\title{Spectrum library cleanining}
\usage{
cleanLib(datLib, clean = TRUE, intensity.cutoff = 5, conf.cutoff = 0.99,
  nomod = FALSE, nomc = FALSE, enz = c("trypsin", "gluc", "chymotrypsin"))
}
\arguments{
\item{datLib}{a data frame for a spectrum library}

\item{clean}{a logic value indicating if the library will be cleaned. Default value is TRUE.}

\item{intensity.cutoff}{A number value to specify cut off for relative 
intensity of fragment ions. Only ions with intensity higher than the
cut off value (default as 5) will be kept.}

\item{conf.cutoff}{A number value to specify cut off for precursor 
confidence. Only ions with confidence higher than the cut off value
(default as 0.99) will be kept.}

\item{nomod}{a logic value, representing if the modified peptides and its
fragment ions will be removed. True (default) means will be removed.}

\item{nomc}{a logic value, representing if peptides with miss cleavages
are removed. Default vaue is False (not to remove).}

\item{enz}{A character string representing the enzyme which can be one of
"trypsin" (defalut), "gluc", or "chymotrypsin"}
}
\value{
a data frame of a cleaned spectrum library by the specified
criteria
}
\description{
Spectrum library cleanining
}
\examples{
file <- paste(system.file("files",package="SwathXtend"),"Lib1.txt",sep="/")
dat <- read.delim2(file,sep="\\t",header=TRUE,stringsAsFactors=FALSE)
dat <- canonicalFormat(dat)
dat <- cleanLib(dat)
}

