\name{applyttestPep}
\alias{applyttestPep}
\title{
Function to apply t-test separately for all peptides of each protein
}
\description{
Generate fold changes and p-values for each protein (col 1) determined by a number of peptides (col 2).
}
\usage{
applyttestPep(peptides, Group, doLogs = TRUE, numerator = levels(as.factor(Group))[1])
}
\arguments{
  \item{peptides}{
	Data frame with two descriptive columns: proteins, peptides, then data in the remaining ncol - 2 columns.
}
  \item{Group}{
	Factor describing data membership.  Must have two levels, and length = ncol(mat) - 2.
}
  \item{doLogs}{
	TRUE/FALSE, log-transform data prior to analysis
}
  \item{numerator}{
	The group level used as the numerator in the fold change.
}
}
\details{
}
\value{
	Data frame with rows Protein, fold change and p-value.
}
\references{
}
\author{
}
\note{
}

\seealso{
\code{\link{applyttest}}
}
\examples{

# make random matrix with first 10 proteins differentially expressed
mat = exp(6+matrix(rnorm(6000), ncol=6))
Protein = sort(paste("P", sample(1:300, 1000, replace=TRUE)))
Peptide = paste("Pep", 1:1000)
for (j in 1:10) mat[Protein == unique(Protein)[j], 4:6] = 3*mat[Protein == unique(Protein)[j], 1:3]

res = applyttestPep(data.frame(Protein, Peptide, mat), rep(c("A", "B"), each=3), numerator="B")
# first 10 proteins should have fold change 3
plot(log(res$FC), -log(res$pval), col=rainbow(2)[1+ as.numeric(1:1000 > 10)])

# add some missing values
mat[5:20,4] = NA
res = applyttestPep(data.frame(Protein, Peptide, mat), rep(c("A", "B"), each=3), numerator="B")
# first 10 proteins should have fold change 3
plot(log(res$FC), -log(res$pval), col=rainbow(2)[1+ as.numeric(1:1000 > 10)])

}
% Add one or more standard keywords, see file 'KEYWORDS' in the
% R documentation directory.
\keyword{ ~kwd1 }
\keyword{ ~kwd2 }% __ONLY ONE__ keyword per line
