###########################################################################
#' Plot for retention time correlation of two libraries
#' @param dat1 A data frame containing the first spectrum library
#' @param dat2 A data frame containing the second spectrum library
#' @param label1 a character string representing the x axis label for plotting
#' @param label2 a character string representing the y axis label for plotting
#' @param nomod a logic value, representing if the modified peptides and its
#' fragment ions will be removed. FALSE (default) means not removing.
#' @examples 
#' libfiles <- paste(system.file("files",package="SwathXtend"),
#'    c("Lib2.txt","Lib3.txt"),sep="/")
#' datBaseLib <- readLibFile(libfiles[1])
#' datExtLib <- readLibFile(libfiles[2])
#' plotRTCor(datBaseLib, datExtLib, "Lib2", "Lib5")
############################################################################ 
plotRTCor <- function(dat1, dat2, label1, label2, nomod=FALSE) {
	datRTrain <- getRTrain(dat1, dat2, nomod=nomod)
	bestModel <- selectModel(datRTrain)
	r2 <- cor(datRTrain[,2],datRTrain[,3])^2
	predicted <- predict(bestModel, newdata=datRTrain)
	rmse <- sqrt(mean((datRTrain[,2]-predicted)^2)) 
	plot(datRTrain[,2],datRTrain[,3],
	   xlab=paste(label1, "RT"),ylab=paste(label2, "RT")) 
	lines(lowess(datRTrain[,2],datRTrain[,3]),col="red")
	r2label <- bquote(italic(R)^2 ==. (format(r2, digits = 2)))
	text(min(datRTrain[,2])+2, max(datRTrain[,3])-2,
	   labels = r2label,pos=4)   
   
   invisible(r2)
}