###########################################################################
#' Plot relative ion intensity correlation of two libraries
#' @param dat1 A data frame containing the first spectrum library
#' @param dat2 A data frame containing the second spectrum library
#' @param nomod a logic value, representing if the modified peptides and its
#' fragment ions will be removed. FALSE (default) means not removing.
#' @examples 
#' libfiles <- paste(system.file("files",package="SwathXtend"),
#'    c("Lib2.txt","Lib3.txt"),sep="/")
#' datBaseLib <- readLibFile(libfiles[1])
#' datExtLib <- readLibFile(libfiles[2])
#' plotRIICor(datBaseLib, datExtLib)
############################################################################ 

plotRIICor <- function(dat1, dat2, nomod=FALSE) {
	datRTrain <- getRTrain(dat1, dat2, nomod=nomod)
	comm.peps <- unique(datRTrain$sequence)
	cols <- c("stripped_sequence", "relative_intensity", "frg_type", "frg_nr",            
	  "frg_z" )
	datlibs.sub = lapply(list(dat1, dat2),
					 function(x){
					   x$stripped_sequence <- paste(x$stripped_sequence,x$modification_sequence)
					   x[x$stripped_sequence %in% comm.peps,cols]})
	datlibs.sub = lapply(datlibs.sub, 
					 function(x) {x$frg_type_nr=
									paste(x$stripped_sequence,x$frg_type,x$frg_nr,x$frg_z)
								  x})							  
	mm = merge(datlibs.sub[[1]][,c(1,2,6)],datlibs.sub[[2]][,c(1,2,6)],by=3,all=FALSE)
	mm = mm[!duplicated(mm$frg_type_nr),c(1,2,3,5)]
	colnames(mm) <- c("frg_type_nr","stripped_sequence","relative_intensity.x",
				  "relative_intensity.y")
	list.ms2 <- split(mm,as.factor(mm$stripped_sequence))
	allCor<-unlist(sapply(list.ms2, FUN=function(x)
	{if(nrow(x)>1 & length(unique(x[,3]))>1 & length(unique(x[,4]))>1) {cor(x[,3],x[,4],method="spearman")}}) ) 
	
	ionCorGS <- NULL; rm(ionCorGS);	
	data(ionCorGS)
	
	boxplot(allCor, ionCorGS, names=c("in study", "gold standard"),
		  col=c("darkgreen", "darkorange"),
		  main="Relative ion intensity correlation between libraries",outline=FALSE)
	abline(h=0.8, col="red")

	invisible(allCor)
}