###########################################################################
#' Convert a data frame into OpenSWATH library format
#' @param dat a data frame of a canonical spectrum library
#' @return a data frame of a spectrum library in OpenSWATH format
#' @examples 
#' libfile <- paste(system.file("files",package="SwathXtend"),"Lib2.txt",sep="/")
#' datlib <- readLibFile(libfile)
#' dat<-openSwathFormat(datlib)
############################################################################ 

openSwathFormat <- function(dat){ 
  
 
  
  openswath.colnames <- c("PrecursorMz","ProductMz","Tr_recalibrated","transition_name","CE",
                          "LibraryIntensity","transition_group_id","decoy","PeptideSequence",
                          "ProteinName","Annotation","FullUniModPeptideName","PrecursorCharge",
                          "GroupLabel","UniprotID","FragmentType","FragmentCharge","FragmentSeriesNumber") 
  
  dat.res <-  data.frame("PrecursorMz" = dat$Q1, 
                         "ProductMz" = dat$Q3,
                         "Tr_recalibrated" = dat$RT_detected,
                         "transition_name" = dat$stripped_sequence,
                         "CE" = -1,
                         "LibraryIntensity" = dat$relative_intensity,
                         "transition_group_id" = dat$stripped_sequence,
                         "decoy" = dat$decoy,
                         "PeptideSequence" = dat$stripped_sequence,
                         "ProteinName" = dat$uniprot_id,
                         "Annotation" = paste(dat$frg_type,dat$frg_nr,sep=""),
                         "FullUniModPeptideName" = dat$modification_sequence,
                         "PrecursorCharge" = dat$prec_z,
                         "GroupLabel" = "light",
                         "UniprotID" = dat$uniprot_id,
                         "FragmentType" = dat$frg_type,
                         "FragmentCharge" = dat$frg_z,
                         "FragmentSeriesNumber" = dat$frg_nr) 
  
  dat.res
}