mlrrep <-
function(mat) {

n = ncol(mat)
nfmat = matrix(0, n, n)
wdmat = matrix(0, n, n)

res.list = list()

# calculate all mlr's
for (i in 2:n) {
 for (j in (1:(i-1)) ) {
	 tp = mlr(na.omit(log(mat[,i]/mat[,j])))
	 res.list[[paste(i,j)]] = tp
	 nfmat[i,j] = tp$nf
	 wdmat[i,j] = tp$wdt
 }
}

wdmat[upper.tri(wdmat)] = t(wdmat)[upper.tri(t(wdmat))]
nfmat[upper.tri(nfmat)] = -t(nfmat)[upper.tri(t(nfmat))]

# find least variable replicate
idx = which.min(apply(wdmat, 1, FUN=sum))

mat.norm = mat
for ( j in setdiff(1:n, idx) ) mat.norm[,j] = exp(nfmat[idx,j])*mat[,j];

list(mat.norm=mat.norm, wdmat=wdmat, nfmat=nfmat, idx=idx)

}
