mlr <-
function(ratio, doplot=FALSE) {

ratio = na.omit(ratio)

if (min(ratio) == max(ratio)) {
if (doplot) hist(ratio, freq=FALSE, breaks = 100);
out = list(nf=0, peak=1, wdt=0)
} else {
res = density(ratio)
mlr = max(res$y)
nf = res$x[which.max(res$y)]
mid = res$x[res$y > mlr/2]
wdt = mid[length(mid)] - mid[1]
out = list( nf=nf, peak=mlr, wdt=wdt)

if (doplot) {
hist(ratio, freq=FALSE, breaks = 100)
lines(res)
abline(v=0, col="red")
abline(v=nf, col="green", lwd=2)
text(nf, mlr, format(nf, digits=3), pos=4)
segments( mid[1], mlr/2, mid[length(mid)], mlr/2, col="blue", lwd=2)
text(mid[length(mid)], mlr/2, format(wdt, digits=3), col="blue", pos=4)
}

}

out
}
