###########################################################################
#' Standardise a data frame into library format
#' @param datlib a data frame for a spectrum library
#' @param colnums a number representing the number of columns to keep 
#' (default as 18)
#' @return a data frame with specified number of columns
#' @examples 
#' libfile <- paste(system.file("files",package="SwathXtend"),"Lib2.txt",sep="/")
#' datlib <- readLibFile(libfile)
#' dat <- libraryFormat(datlib)
############################################################################ 

libraryFormat <- function(datlib, colnums = 18)
{
  
  inclcols = c("Q1","Q3",
               "RT_detected",
               "protein_name",
               "isotype",
               "relative_intensity",
               "stripped_sequence",
               "modification_sequence",
               "prec_z",
               "frg_type",
               "frg_z",
               "frg_nr",
               "iRT",
               "uniprot_id",
               "decoy",
               "confidence",
               "shared",
               "N")

  datlib[,inclcols]
  

}