###########################################################################
#' Plot for ion intensity ranking correlation of two libraries
#' @param dat1 A data frame containing the first spectrum library
#' @param dat2 A data frame containing the second spectrum library
#' @param method a character string indicating the method for calculating
#' @param wb an openxlsx workbook object
#' @param sheet A name or index of a worksheet
#' correlation coefficient. Either of "spearman" (default) or "kendall".
#' @return a .png file of boxplot for the ion intensity ranking correlation
#' between the two libraries
#' @examples 
#' file1 <- paste(system.file("files",package="SwathXtend"),"Lib2.txt",sep="/")
#' file2 <- paste(system.file("files",package="SwathXtend"),"Lib3.txt",sep="/")
#' dat1 <- normalise(readLibFile(file1))
#' dat2 <- normalise(readLibFile(file2))
#' computeRIICor(dat1, dat2)
############################################################################ 


computeRIICor <- function(dat1,dat2, method = "spearman", wb=NULL, sheet=NULL, nomod=FALSE)

{
  
  datRTrain <- getRTrain(dat1, dat2, nomod=nomod)
  
  comm.peps <- unique(datRTrain$sequence)
  
#   comm.peps <- unique(intersect(dat1$stripped_sequence,
#                                 dat2$stripped_sequence))

  cols <- c("stripped_sequence", "relative_intensity", "frg_type", "frg_nr",            
          "frg_z" )
   
  if(nomod) { 

    
    datlibs.sub = lapply(list(dat1, dat2),
                         function(x){x[x$stripped_sequence %in% 
                                         comm.peps,cols]})
    
    datlibs.sub = lapply(datlibs.sub, 
                         function(x) {x$frg_type_nr=
                                        paste(x$stripped_sequence,x$frg_type,x$frg_nr,x$frg_z)
                                      x})
  } else { # with modification
    
    
    datlibs.sub = lapply(list(dat1, dat2),
                         function(x){
                           x$stripped_sequence <- paste(x$stripped_sequence,x$modification_sequence)
                           x[x$stripped_sequence %in% comm.peps,cols]})
    
    datlibs.sub = lapply(datlibs.sub, 
                         function(x) {x$frg_type_nr=
                                        paste(x$stripped_sequence,x$frg_type,x$frg_nr,x$frg_z)
                                      x})
  }

  
  mm = merge(datlibs.sub[[1]][,c(1,2,6)],datlibs.sub[[2]][,c(1,2,6)],by=3,all=FALSE)
  if(nrow(mm) > 5){
    mm = mm[!duplicated(mm$frg_type_nr),c(1,2,3,5)]
    
    colnames(mm) <- c("frg_type_nr","stripped_sequence","relative_intensity.x",
                      "relative_intensity.y")
    ## correlation statistics
    
    list.ms2 <- split(mm,as.factor(mm$stripped_sequence))
    
    
    if(length(list.ms2) > 1){
      allCor<-unlist(sapply(list.ms2, FUN=function(x)
        {if(nrow(x)>1 & length(unique(x[,3]))>1 & length(unique(x[,4]))>1) {cor(x[,3],x[,4],method=method)}}) ) 
            
      ionCorGS<-NULL; rm(ionCorGS);
      data(ionCorGS)
      

		  png("IonIntensityCorrelation.png")

		  boxplot(allCor, ionCorGS, names=c("in study", "gold standard"),
				  col=c("darkgreen", "darkorange"),
				  main="Relative ion intensity correlation between libraries",outline=FALSE)
		  abline(h=0.8, col="red")
		  
		  
		  dev.off()
		  
		  if(!is.null(wb) & !is.null(sheet))
			insertImage(wb, sheet, "IonIntensityCorrelation.png", width=6, height=5, startRow=1, startCol=1)
		  

	}
  }
  
  allCor
}