applyttest <-
function(mat, Group, doLogs=TRUE,  numerator=levels(Group)[1]) {

Group = as.factor(as.vector(Group))
mat = as.matrix(mat)

pval = rep(NA, nrow(mat))
FC = rep(NA, nrow(mat))

if (doLogs == TRUE) mat = log(mat);
if (!(nlevels(Group) == 2)) stop("T test needs two levels only in group.");

pval = sapply(1:nrow(mat), FUN=function(i){
 res = NA
 tp = try(t.test(mat[i,] ~ Group, var.equal=TRUE))
 if (!inherits(tp, "try-error")) res = tp$p.value
 res
 })

mn.1 =  apply(mat[,Group == numerator], 1, FUN=function(v){mean(na.omit(v))})
mn.2 =  apply(mat[,Group == setdiff(levels(Group), numerator)], 1, FUN=function(v){mean(na.omit(v))})

if (doLogs) {
	FC = exp(mn.1)/exp(mn.2)
} else {
FC = mn.1/mn.2
}

data.frame(pval, FC)

}
