% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GEOmetadata.R
\name{GEOmetadata}
\alias{GEOmetadata}
\title{GEOmetadata function}
\usage{
GEOmetadata(GSE, GPL = "")
}
\arguments{
\item{GSE}{The GSE series ID.}

\item{GPL}{The GPL series numbers.
Required only if the chosen GSE series ID include data from multiple sequencing platforms.}
}
\value{
A dataframe with all the available characteristics in GEO metadata \code{genes} array.
}
\description{
Download metadata from \url{https://www.ncbi.nlm.nih.gov/geo},
given an input GEO accession series.
}
\section{Warning}{

If the GEO accession series has more than 1 sequencing platforms you need to
specify the GPL series numbers.
}

\examples{
# only one sequencing platform
\dontrun{
mGSE133671 <- GEOmetadata(GSE = "GSE133671")
# multiple sequencing platforms
mGSE59483 <- GEOmetadata("GSE59483", GPL = c("GPL11154", "GPL15520"))}
}
\seealso{
\url{https://www.ncbi.nlm.nih.gov/geo} for info on GEO repository

Other public-data functions: 
\code{\link{DownloadArchS4}()},
\code{\link{TCGA_download}()}
}
\concept{public-data functions}
