% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Enrichment_barplot.R
\name{Enrichment_barplot}
\alias{Enrichment_barplot}
\title{Enrichment_barplot}
\usage{
Enrichment_barplot(
  Enrich,
  enrich.databases = c("GO_Biological_Process_2021", "GO_Cellular_Component_2021",
    "GO_Molecular_Function_2021"),
  p_adj = 0.05,
  num_term = 10,
  cond = "UP",
  plot = FALSE
)
}
\arguments{
\item{Enrich}{A list of enrichment tables for up and down-regulated genes in the different enrichR databases.
Output of Enrichment.R function for one DGE experiment.}

\item{enrich.databases}{Vector of EnrichR databases to consider. These databases must be present in the Enrich list.}

\item{p_adj}{Double. Minimum Adjusted pvalue threshold for the enrichment}

\item{num_term}{Double. Number of up-regulated and dw-regulated terms to represent}

\item{cond}{String. Title of the plot.}

\item{plot}{Logical. If TRUE save plot as pdf.}
}
\value{
bar plot of significant pathways.
}
\description{
Barplot representing the top up-regulated or down-regulated significant pathways
}
\examples{
\dontrun{
dbs <- c("GO_Biological_Process_2021")
dfList <- list()
dfList[["fdr_up"]]$GO_Biological_Process_2021 <- data.frame(
  Term = c("peripheral nervous system neuron differentiation (GO:0048934)",
           "apoptotic chromosome condensation (GO:0030263)",
           "negative regulation of CD4-positive, alpha-beta T cell differentiation (GO:0043371)"),
  Overlap = c("1/5", "1/5", "1/5"),
  P.value = c(0.0007498315, 0.0007498315, 0.0007498315),
  Adjusted.P.value = c(0.00893491, 0.00893491, 0.00893491),
  Old.P.value = c(0, 0, 0),
  Old.Adjusted.P.value = c(0, 0, 0),
  Odds.Ratio = c(2499.125, 2499.125, 2499.125),
  Combined.Score = c(17982.86, 17982.86, 17982.86),
  Genes = c("RUNX1", "TOP2A", "RUNX1"))
dfList[["fdr_down"]]$GO_Biological_Process_2021 <- data.frame(
  Term = c("skin morphogenesis (GO:0043589)",
           "skin development (GO:0043588)",
           "collagen fibril organization (GO:0030199)"),
  Overlap = c("2/7", "2/80", "2/89"),
  P.value = c(3.149296e-07, 4.727687e-05, 5.856991e-05),
  Adjusted.P.value = c(1.291211e-05, 8.004554e-04, 8.004554e-04),
  Old.P.value = c(0, 0, 0),
  Old.Adjusted.P.value = c(0, 0, 0),
  Odds.Ratio = c(7996.8000, 510.7436, 457.7011),
  Combined.Score = c(119719.427, 5086.745, 4460.430),
  Genes = c("COL1A1;COL1A2", "COL1A1;COL1A2", "COL1A1;COL1A2"))
Enrichment_barplot(dfList,
                   enrich.databases = dbs,
                   p_adj = 0.01, num_term = 3, cond = "UP")
}
}
\seealso{
Other functional-annotation functions: 
\code{\link{Annotate_SPID}()},
\code{\link{Enrichment}()}

Other plot functions: 
\code{\link{SVenn}()},
\code{\link{Splot}()},
\code{\link{plotPCA}()}
}
\concept{functional-annotation functions}
\concept{plot functions}
