% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/Structstrings-conversion.R
\name{getBasePairing}
\alias{getBasePairing}
\alias{getDotBracket}
\alias{getLoopIndices}
\alias{getBasePairing,DotBracketString-method}
\alias{getBasePairing,DotBracketStringSet-method}
\alias{getDotBracket,DotBracketDataFrame-method}
\alias{getDotBracket,DotBracketDataFrameList-method}
\alias{getDotBracket,SimpleSplitDotBracketDataFrameList-method}
\alias{getDotBracket,CompressedSplitDotBracketDataFrameList-method}
\alias{getLoopIndices,DotBracketString-method}
\alias{getLoopIndices,DotBracketStringSet-method}
\alias{getLoopIndices,DotBracketDataFrame-method}
\alias{getLoopIndices,DotBracketDataFrameList-method}
\alias{getLoopIndices,SimpleSplitDotBracketDataFrameList-method}
\alias{getLoopIndices,CompressedSplitDotBracketDataFrameList-method}
\title{Accessing Dot Bracket annotation}
\usage{
getBasePairing(x, compress = TRUE, return.sequence = FALSE)

getDotBracket(x, force = FALSE)

getLoopIndices(x, bracket.type, warn.type.drops = TRUE)

\S4method{getBasePairing}{DotBracketString}(x)

\S4method{getBasePairing}{DotBracketStringSet}(x, compress = TRUE)

\S4method{getDotBracket}{DotBracketDataFrame}(x, force = FALSE)

\S4method{getDotBracket}{DotBracketDataFrameList}(x, force = FALSE)

\S4method{getDotBracket}{SimpleSplitDotBracketDataFrameList}(x, force = FALSE)

\S4method{getDotBracket}{CompressedSplitDotBracketDataFrameList}(x, force = FALSE)

\S4method{getLoopIndices}{DotBracketString}(x, bracket.type, warn.type.drops = TRUE)

\S4method{getLoopIndices}{DotBracketStringSet}(x, bracket.type, warn.type.drops = TRUE)

\S4method{getLoopIndices}{DotBracketDataFrame}(x, bracket.type, warn.type.drops = TRUE)

\S4method{getLoopIndices}{DotBracketDataFrameList}(x, bracket.type, warn.type.drops = TRUE)

\S4method{getLoopIndices}{SimpleSplitDotBracketDataFrameList}(x, bracket.type, warn.type.drops = TRUE)

\S4method{getLoopIndices}{CompressedSplitDotBracketDataFrameList}(x, bracket.type, warn.type.drops = TRUE)
}
\arguments{
\item{x}{a \code{\link{DotBracketString}} or
\code{\link{DotBracketStringSet}} object}

\item{compress}{\code{getBasePairing}: whether to return a
\code{CompressedSplitDotBracketDataFrameList} or a
\code{SimpleSplitDotBracketDataFrameList}}

\item{return.sequence}{if the input is a \code{StructuredXStringSet}:
\code{TRUE}(default) or \code{FALSE}: Whether the sequence should be
returned in the \code{base} column.}

\item{force}{\code{getDotBracket}: Should the dot bracket string be
generated from the base pairing, if the \code{character} column is present?}

\item{bracket.type}{\code{getLoopIndices}: Which dot bracket annotation type
should be converted into loop indices? Only usable, if more than one is
present. (\code{1L = '()', 2L = '<>', 3L = '[]', 4L = '{}'})}

\item{warn.type.drops}{\code{getLoopIndices}: \code{TRUE}(default) or
\code{FALSE}: Warn if more than one dot bracket annotation type is present
in the input?}
}
\value{
\code{getBasePairing}: 
The result is a \code{\link{DotBracketDataFrame}} with following columns:
pos, forward, reverse, character (and optionally the base column). If a
position is unpaired, forward and reverse will be \code{0}, otherwise it will
match the base paired positions.

\code{getLoopIndices}: returns a \code{\link{LoopIndexList}}.
}
\description{
\code{getBasePairing} converts a dot bracket annotation from a 
\code{\link{DotBracketString}} into a base pair table as 
\code{\link{DotBracketDataFrame}}. Base pairing is indicated by corresponding
numbers in the forward and reverse columns.

\code{getDotBracket} converts the dot bracket annotation from a
\code{\link{DotBracketDataFrame}} into a \code{\link{DotBracketString}}. If
the \code{character} colums is populated, the information from this column
will be used. If this is not desired set \code{force = TRUE}. However ,
beaware that this will result in a dot bracket annotation, which does not
necessarilly  matches the original dot bracket string it may have been
created from. It is rather the dot bracket string with the lowest number of
different loops and it will use the different dot bracket annotations one
after another. Example: "(((<<<>>>)))" will be returned as
\code{(((((())))))}. \code{(((<<<)))>>>} will be returned as
\code{(((<<<)))>>>}, \code{((([[[)))]]]} will be eturned as
\code{(((<<<)))>>>}.

\code{getLoopIndices} converts the dot bracket annotation from a
\code{\link{DotBracketString}} or \code{DotBracketDataFrame} into a
\code{\link{LoopIndexList}}.
}
\examples{
data("dbs", package = "Structstrings")
# conversion
dbdf <- getBasePairing(dbs)
# ... and the round trip
dbs <- getDotBracket(dbdf)

# loop indices per bracket type
loopids <- getLoopIndices(dbs)
# choose the bracket type manually, if necessary
loopids <- getLoopIndices(dbs, bracket.type = 1L)
# do not show warning if mulitple bracket types are present
loopids <- getLoopIndices(dbs, bracket.type = 1L, warn.type.drops = FALSE)
}
