% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Statial.R
\name{getAbundances}
\alias{getAbundances}
\title{Wrapper to calculate imhomogenous K function between a cell and surrounding
types on each image}
\usage{
getAbundances(
  cells,
  r = 200,
  distFun = "abundance",
  redDimName = "abundances",
  cellType = "cellType",
  imageID = "imageID",
  spatialCoords = c("x", "y"),
  nCores = 1
)
}
\arguments{
\item{cells}{A dataframe with a cellType column as well as x and y spatial coordinates.
The dataframe must contain a imageID column and cellID (unique cell
identifier's) column as well}

\item{r}{Radius to include in that calculation of pairwise abundance (K-function)
between cells (can be a numeric or vector of radii)}

\item{distFun}{What distance function to use.}

\item{redDimName}{Name of the reduced dimension to store in sce.}

\item{cellType}{The name of the column in colData that stores the cell types.}

\item{imageID}{The name of the column in colData that Stores the image ids.}

\item{spatialCoords}{The names of the columns in colData that store the spatial coordinates.}

\item{nCores}{Number of cores for parallel processing}
}
\description{
Calculate the imhomogenous K function (a measure of cell type abundance) for
each cell to other cell types
}
\examples{
library(dplyr)
data("kerenSCE")

singleCellDataCounts <- getAbundances(kerenSCE,
  r = 200,
)

}
