% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/StatescopeR-package.R
\docType{package}
\name{StatescopeR-package}
\alias{StatescopeR-package}
\alias{StatescopeR}
\title{The StatescopeR package}
\description{
framework for discovery of cell states from bulk mRNA profiles
}
\section{Details}{

 StatescopeR starts from lognormalized cp10k single cell data and a bulk RNA
 dataset to be used for deconvolution and cell state analysis. From this
 point StatescopeR has some functions to create a signature and select genes
 for deconvolution.
 \code{\link{create_signature}} creates a signature of lognormalized cp10k
     single cell data for deconvolution and cell state analysis.
 \code{\link{select_genes}} selects genes which best discriminate cell types
     for use in deconvolution.
 Alternatively you can also use:
  \code{\link{fetch_signature}} to fetch one of the premade signatures +
  selected_genes from https://github.com/tgac-vumc/StatescopeData
  After these steps and proper cp10k normalization of the bulk mRNA
  deconvolution and cell state analysis can be done with the following
   functions:
 \code{\link{BLADE_deconvolution}} estimates cell fractions from bulk mRNA.
 \code{\link{Refinement}} refines cell type-specific gene expression profile
     estimates to better capture inter-sample variability.
 \code{\link{StateDiscovery}} discovery cell states from inferred cell
 type-specific gene expression profiles.

 After these steps the following functions provide some evaluation
     and plotting functions:
 \code{\link{gather_true_fractions}} gets true cell fractions from
     scRNAseq data.
 \code{\link{fraction_eval}} plots the correlation of estimated vs true
     cell fractionsover all samples.
 \code{\link{fraction_heatmap}} plots a heatmap of estimated
     cell fractions.
 \code{\link{barplot_stateloadings}} plots a barplot showing the top n
     most important stateloadings.
}

\seealso{
Useful links:
\itemize{
  \item \url{https://github.com/tgac-vumc/StatescopeR}
  \item Report bugs at \url{https://github.com/tgac-vumc/StatescopeR/issues}
}

}
\author{
\strong{Maintainer}: Mischa Stetketee \email{m.f.b.steketee@amsterdamumc.nl} (\href{https://orcid.org/0000-0001-7138-7554}{ORCID})

Other contributors:
\itemize{
  \item KWF [funder]
}

}
\keyword{internal}
