% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualize_label.R
\name{visualizeLabel}
\alias{visualizeLabel}
\alias{visualizeLabel.default}
\alias{visualizeLabel.SummarizedExperiment}
\title{Visualize spot labels on the 2D slide}
\usage{
visualizeLabel(object, ...)

\method{visualizeLabel}{default}(
  object,
  label = "tissue",
  subset_barcodes = NULL,
  title = "",
  legend_title = NULL,
  ...
)

\method{visualizeLabel}{SummarizedExperiment}(
  object,
  label = "tissue",
  subset_barcodes = NULL,
  title = "",
  legend_title = NULL,
  ...
)
}
\arguments{
\item{object}{A slide object created or
inherited from \code{createSlide()}, or a \code{data.frame} of slide
information with columns: barcodes, tissue, imagerow, imagecol, etc.}

\item{...}{Arguments passed to other methods}

\item{label}{(categorical vector or chr) Either a vector of labels for all
spots, or the column name in the \code{slide} slot of the slide
object's metadata. In the former case, the order of values in the vector
should match the spot barcodes in the slide object. In the latter case,
The column should be categorical with reasonably number of unique labels.
Default: \code{"tissue"}}

\item{subset_barcodes}{(vector of chr) A subset of spot barcodes to plot.
By default it plots all spots in the slide object. This can be useful
when only plotting tissue spots or specific tissue types or regions.
Default: \code{NULL}}

\item{title}{(chr) Title of the plot. Default: \code{""}}

\item{legend_title}{(chr) Title of the legend. Under default,
use \code{label} as legend title. Default: \code{NULL}}
}
\value{
A \code{ggplot2} object.
}
\description{
Generate and visualize spot labels on the 2D slide
as a ggplot2 object. Spot labels can be given via parameter \code{label} as
external input or one column in the \code{slide} slot of the slide
object's metadata via \code{label_col}. Exactly one of \code{label}
and \code{label_col} must be specified.
}
\examples{

data(mbrain_raw)
spatial_dir <- system.file(file.path("extdata",
                                     "V1_Adult_Mouse_Brain_spatial"),
                           package = "SpotClean")
mbrain_slide_info <- read10xSlide(tissue_csv_file=file.path(spatial_dir,
                                       "tissue_positions_list.csv"),
             tissue_img_file = file.path(spatial_dir,
                                       "tissue_lowres_image.png"),
             scale_factor_file = file.path(spatial_dir,
                                       "scalefactors_json.json"))
mbrain_obj <- createSlide(mbrain_raw,
                          mbrain_slide_info)
gp <- visualizeLabel(mbrain_obj, label="tissue",
                     title="mbrain", legend_title="tissue or background")
plot(gp)

}
