% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\name{splineHVG}
\alias{splineHVG}
\title{Spline-HVG}
\usage{
splineHVG(
  X,
  QC = TRUE,
  ncounts = 1000,
  ncells = 15,
  mtPerc = 15,
  spar = 0.5,
  nHVGs = 2000,
  use.ndist = TRUE,
  verbose = TRUE
)
}
\arguments{
\item{X}{Count matrix or SingleCellExperiment}

\item{QC}{A Boolean value (TRUE/FALSE), if TRUE, a quality control is applied over the data.}

\item{ncounts}{An integer value. Defines the minimum reads required for a cell to be included in the analysis.}

\item{ncells}{An integer value. Defines the minimum cells required for a gene to be included in the analysis.}

\item{mtPerc}{A double value. Defines the minimum percent mitochondrial genes expression required for a cell to be excluded from the analysis.}

\item{spar}{A double value. Smoothing parameter for Spline.}

\item{nHVGs}{An integer value. Number of top Highly Variable Genes (HVGs) to select.}

\item{use.ndist}{A Boolean value (TRUE/FALSE), if TRUE, computes the nearest point on spline by nearest-neighbor search (TRUE Recommended). Else, uses the position of the corresponding gene on the spline for distance computation.}

\item{verbose}{A Boolean value (TRUE/FALSE), if TRUE, prints messages.}
}
\value{
A DataFrame with highly variable gene selection statistics. The statistics include log1p(mean), log1p(CV), dropout rates, nearest point on spline (splinex, spliney and splinez) and distance from spline. A higher distance signifies higher variability.
}
\description{
Compute Highly Variable Genes from an scRNAseq expression data. Uses 3 gene statstics - Mean, CV and Dropout rate to model a 3D spline to estimate the expected behavior of genes. A gene is considered highly variable if the actual gene expression is far from the estimated 3D spline.
}
\examples{
# example code
## Generate example count data
X <- abs(matrix(round(rpois(2000*500, lambda=0.5),0), nrow=2000, ncol=500))
rownames(X) <- paste0('g', as.character(1:2000))

## Run splineHVG
res <- splineHVG(X)
}
\author{
Shreyan Gupta <xenon8778@tamu.edu>
}
