\name{SpeCond}
\alias{SpeCond}
\title{The condition-specific detection function}
\description{
\code{SpeCond} performs a full condition-specific detection from an expression matrix
}
\usage{
SpeCond(expressionMatrix, param.detection = NULL, 
multitest.correction.method = "BY", prefix.file = "A",
print.hist.pv = FALSE, fit1 = NULL, fit2 = NULL, 
specificOutlierStep1 = NULL, condition.factor=NULL, 
condition.method=c("mean","max"))
}

\arguments{
  \item{expressionMatrix}{an ExpressionSet object or a matrix of expression values (in log2); columns are the conditions, rows are genes (or probe sets)}
  \item{param.detection}{the parameter matrix for the detection must contain the values for "lambda", "beta", "per", "md", "mlk" ,"rsd' and "pv" for the two steps of the procedure. Can be obtained by \code{getDefaultParameter} or \code{createParameterMatrix}}
  \item{multitest.correction.method}{the multitest correction method. The default is "BY", for the possible values see \code{p.adjust}}
\item{prefix.file}{a prefix added to the histogram file (if produced). It will be used to link to the result html pages generated by other functions using the result object of this function (if no other prefix value is implemented). The default is "A". It is useful to change the prefix when you perform a new analysis with different parameters as you may want to compare the results}
  \item{print.hist.pv}{a logical (TRUE/FALSE) value indicating whether a histogram of (non-adjusted) p-values is to be printed; the default is FALSE}
Optional parameters:
  \item{fit1}{the result of \code{fitPrior} containing the parameter of the mixture normal model of the expression data. If NULL \code{fitPrior} function will be called }
  \item{fit2}{the result of \code{fitNoPriorWithExclusion} containing the parameter of the mixture normal model of the expression data ignoring the outliers detected in the first step of the procedure. If NULL, \code{fitNoPriorWithExclusion} function will be called}
  \item{specificOutlierStep1}{the list of outliers detected by the first step procedure, result of the 
  \code{getSpecificOtuliersStep1} function. If NULL, \code{getSpecifcOutliersSpep1} will be called}
  \item{condition.factor}{this argument can be used if expressionMatrix is an ExpressionSet object; a factor object of length equal to the number of columns (samples) of the ExpressionSet object specifying which sample(s) belong to which condition (condition.factor levels); can be extracted from the phenoData}
  \item{condition.method}{this argument can be used if expressionMatrix is an ExpressionSet object;  the method (mean or max) to summarise the samples by conditions (defined by the condition.factor vector)}
}
\value{
An object of class \code{sp_list}
  \item{prefix.file}{the prefix used for this analysis. It will be used by default in the function \code{getFullHtmlSpeCondResult} and \code{getGeneHtmlPage}}
  \item{fit1}{the fitting parameters used by the detection in the first step of the procedure: the result of the \code{fitPrior} function called internally or the same as the fit1 argument if not NULL}
  \item{fit2}{the fitting parameters used by the detection in the second step of the procedure: the result of the \code{fitNoPriorWithExclusion} function called internally or the same as the fit2 argument if not NULL}
  \item{specificOutliersStep1}{the condition(s) for which the expression value of the gene is detected as outlier in the first step of the procedure. If NULL, no expression value has been detected in the first step. The second fitting ignores these expression values}
  \item{specificResult}{ a list of 7 attributes containing al the specific results. This object result of \code{getSpecificResult}}
}
\details{
SpeCond uses the \code{Mclust} function to obtain the mixture of normal distributions uses by the detection procedure.

If \code{expressionMatrix} is an ExpressionSet object it is necessary to obtain an expression value matrix. This is obtain by the \code{getMatrixFromExpressionSet} function. This take into consideration if \code{condition.factor} is not NULL the transformation of the expression values for the several samples of each condition to one expression values for each condition for each gene.

If \code{print.hist.pv} is TRUE the histogramme of the non-adjusted p-values is plotted. It is a way to check the normal distribution fitting. If the histogramme is relatively flat the normal distribution(s) fits properly the data.
}
\references{
C.Fraley and A. E. Raftery, Model-based clustering, discriminant analysis, and density estimation,
 \emph{Journal of the American Statistical Association, Vol. 97, pages 611-631 (2002)}.

C. Fraley and A. E. Raftery, MCLUST Version 3 for R: Normal Mixture Modeling and Model-based Clustering, 
Technical Report No. 504, Department of Statistics, University of Washington, September 2006.
}
\author{Florence Cavalli, florence@ebi.ac.uk}
\seealso{\code{Mclust}, \code{fitPrior}, \code{fitNoPriorwithExclusion},
\code{getSpecificOutliersStep1}, \code{getSpecificResult}}

\examples{
library(SpeCond)
data(expressionSpeCondExample)
dim(expressionSpeCondExample)
##Perform the condition specific detection analysis with SpeCond()
generalResult=SpeCond(expressionSpeCondExample, param.detection=NULL, 
multitest.correction.method="BY", prefix.file="E", print.hist.pv=TRUE, 
fit1=NULL, fit2=NULL, specificOutlierStep1=NULL)
}
