% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/imageManipulation.R
\name{cropTissue}
\alias{cropTissue}
\title{Crop to remove black boundary around tissue.}
\usage{
cropTissue(overlay, buffer = 0.05)
}
\arguments{
\item{overlay}{SpatialOverlay object}

\item{buffer}{percent of new image size to add to each edge as a buffer}
}
\value{
SpatialOverlay object
}
\description{
Crop to remove black boundary around tissue.
}
\examples{

muBrain <- readRDS(unzip(system.file("extdata", "muBrainSubset_SpatialOverlay.zip", 
                                    package = "SpatialOmicsOverlay")))

image <- downloadMouseBrainImage()

muBrain <- addImageOmeTiff(overlay = muBrain, 
                           ometiff = image, res = 8)

muBrainCrop <- cropTissue(overlay = muBrain)

plotSpatialOverlay(overlay = muBrainCrop, legend = FALSE, 
                   hiRes = FALSE, scaleBar = FALSE)
            
}
