% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/readCosMx.R
\name{updateCosmxSPE}
\alias{updateCosmxSPE}
\title{updateCosmxSPE}
\usage{
updateCosmxSPE(
  spe,
  dirName,
  sampleName = "sample01",
  polygonsFPattern = "polygons.csv",
  fovdims = c(xdim = 4256, ydim = 4256),
  keepPolygons = FALSE
)
}
\arguments{
\item{spe}{SpatialExperiment object.}

\item{dirName}{Directory containing CosMx output files (e.g., polygon CSVs).}

\item{sampleName}{Character scalar, sample identifier stored in
\code{colData(spe)$sample_id}. Default \code{"sample01"}.}

\item{polygonsFPattern}{Character, pattern used by \code{list.files()} to
locate polygon files. Default \code{"polygons.csv"}.}

\item{fovdims}{Named numeric vector with entries \code{xdim} and \code{ydim}
representing the FOV dimensions in pixels.}

\item{keepPolygons}{Logical indicating if the polygons need to be loaded into
memory or not (Default is `FALSE`).}
}
\value{
A SpatialExperiment object with updated metadata and column names.
}
\description{
Update a SpatialExperiment object derived from CosMx data by adding
polygons, FOV dimensions, standardized column names, and metadata.
}
\details{
The function standardizes CosMx SPE structure by:
- creating unique cell names of the form \code{f<fov>_c<cell_ID>};
- ensuring consistent cell identifiers and sample metadata;
- recording FOV dimensions, polygon paths, and technology type in
  \code{metadata(spe)}.
}
\examples{
cospath <- system.file(file.path("extdata", "CosMx_DBKero_Tiny"),
    package="SpaceTrooper")
spe <- SpatialExperimentIO::readCosmxSXE(dirName=cospath,
    addParquetPaths=FALSE)
spe <- updateCosmxSPE(spe, dirName=cospath, sampleName="DBKero_Tiny")
}
\seealso{
readCosmxSPE, readCosmxProteinSPE
}
