% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/readCosMx.R
\name{updateCosmxProteinSPE}
\alias{updateCosmxProteinSPE}
\title{updateCosmxProteinSPE}
\usage{
updateCosmxProteinSPE(
  spe,
  dirName,
  sampleName = "sample01",
  coordNames = c("CenterX_global_px", "CenterY_global_px"),
  countMatFPattern = "exprMat_file.csv",
  metadataFPattern = "metadata_file.csv",
  polygonsFPattern = "polygons.csv",
  fovPosFPattern = "fov_positions_file.csv",
  fovdims = c(xdim = 4256, ydim = 4256),
  keepPolygons = FALSE
)
}
\arguments{
\item{spe}{SpatialExperiment object.}

\item{dirName}{Directory containing CosMx Protein data files.}

\item{sampleName}{Character sample ID. Default \code{"sample01"}.}

\item{coordNames}{Character vector of length two indicating coordinate
column names in the per-cell metadata. Default
\code{c("CenterX_global_px","CenterY_global_px")}.}

\item{countMatFPattern}{Character pattern for the counts matrix file.}

\item{metadataFPattern}{Character pattern for the single-cell metadata file.}

\item{polygonsFPattern}{Character pattern for the polygon file(s).}

\item{fovPosFPattern}{Character pattern for the FOV positions file.}

\item{fovdims}{Named numeric vector with FOV size in pixels.}

\item{keepPolygons}{Logical indicating if the polygons need to be loaded into
memory or not (Default is `FALSE`).}
}
\value{
SpatialExperiment object with updated technology metadata.
}
\description{
Update a SpatialExperiment object corresponding to Nanostring CosMx
Protein data by adding metadata identifying the technology and
optionally passing through file-location parameters.
}
\details{
This function sets \code{metadata(spe)$technology <- "Nanostring_CosMx_Protein"}.
It does not modify other assay or metadata components.
}
\examples{
protfolder <- system.file( "extdata", "S01_prot", package="SpaceTrooper")
spe <- SpatialExperimentIO::readCosmxSXE(dirName=protfolder,
    addParquetPaths=FALSE)
spe <- updateCosmxProteinSPE(spe, protfolder, sampleName="cosmx_prots")
}
\seealso{
readCosmxProteinSPE, readCosmxSPE
}
