% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/readMerfish.R
\name{readMerfishSPE}
\alias{readMerfishSPE}
\title{readMerfishSPE}
\usage{
readMerfishSPE(
  dirName,
  sampleName = "sample01",
  computeMissingMetrics = TRUE,
  keepPolygons = FALSE,
  boundariesType = c("parquet", "HDF5"),
  countmatFPattern = "cell_by_gene.csv",
  metadataFPattern = "cell_metadata.csv",
  polygonsFPattern = "cell_boundaries.parquet",
  coordNames = c("center_x", "center_y"),
  polygonsCol = "polygons",
  useVolume = TRUE
)
}
\arguments{
\item{dirName}{`character(1)`
Path to a folder containing MERFISH output files.}

\item{sampleName}{`character(1)`
Identifier to assign to the `sample_id` field in the returned object.
Default: `"sample01"`.}

\item{computeMissingMetrics}{`logical(1)`
If `TRUE`, compute area and aspect‐ratio metrics from the cell boundary
polygons. Default: `TRUE`.
In particular for area, if a "volume" column is present in the colData, it
will be used as area value, otherwise area will be computed from polygons.
This is relevant for MERFISH as the volume is computed on the entire 3D
cell available data, while polygons are 2D sections.}

\item{keepPolygons}{`logical(1)`
If `TRUE`, attach raw polygon geometries as extra columns in `colData`.
Default: `FALSE`.}

\item{boundariesType}{`character(1)`
One of `"parquet"` or `"HDF5"`. If `"parquet"`, reads a single Parquet
file of boundaries; if `"HDF5"`, uses a folder of HDF5 polygon files.}

\item{countmatFPattern}{`character(1)`
Regex passed to `list.files()` to find the count matrix CSV. Default:
`"cell_by_gene.csv"`.}

\item{metadataFPattern}{`character(1)`
Pattern to find the cell metadata CSV. Default: `"cell_metadata.csv"`.}

\item{polygonsFPattern}{`character(1)`
Pattern to find the cell boundaries file. Default:
`"cell_boundaries.parquet"`.}

\item{coordNames}{`character(2)`
Names of the columns in `colData` that store X/Y spatial coordinates.
Default: `c("center_x", "center_y")`.}

\item{polygonsCol}{character indicating the name of the polygons column to
add into the colData (default is `polygons`).}

\item{useVolume}{`logical(1)` If `TRUE`, prefer a "volume" column in the
metadata for area (when present). Default: `TRUE`.}
}
\value{
A `SpatialExperiment` object with:
  - `assays$counts`: gene × cell count matrix
  - `colData`: per‐cell metadata (including computed metrics)
  - spatial coordinates named by `coordNames`
  - `metadata$polygons`: path to the boundaries file
  - `metadata$technology`: `"Vizgen_MERFISH"`.
}
\description{
`readMerfishSPE()` imports MERFISH/Merscore outputs (counts, metadata,
and optionally cell boundary polygons) from a directory and builds a
SpatialExperiment object.
}
\details{
The function searches `dirName` for three resources using the provided
filename patterns: the count matrix (`countmatFPattern`), the cell metadata
(`metadataFPattern`), and the polygon resource (`polygonsFPattern`). The
count matrix and metadata are expected to contain a `cell_id` column
(aliases `V1`, `cell`, or `EntityID` are renamed). If `computeMissingMetrics`
is TRUE, `computeMissingMetricsMerfish()` is invoked and receives `useVolume`.

The returned `SpatialExperiment` contains:
- `assays$counts`: gene × cell count matrix (rows = genes, cols = `cell_id`);
- `colData`: per-cell metadata (may be reordered by the function);
- spatial coordinates named by `coordNames`;
- `metadata$polygons`: path(s) matched by `polygonsFPattern`;
- `metadata$technology`: `"Vizgen_MERFISH"`.

Side effects: the function may reorder `colData` columns, attach polygon
file paths to `metadata(spe)$polygons`, and (when requested) append
`Area_um` and `AspectRatio` to `colData`.
}
\examples{
path <- system.file("extdata", "Merfish_Tiny",
                    package = "SpaceTrooper")
spe <- readMerfishSPE(
  dirName = path,
  sampleName = "Patient2",
  keepPolygons = TRUE,
  boundariesType = "parquet"
)
spe
}
\author{
Dario Righelli, Benedetta Banzi
}
