% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/readCosMx.R
\name{readCosmxSPE}
\alias{readCosmxSPE}
\alias{readCosmxProteinSPE}
\title{readCosmxSPE}
\usage{
readCosmxSPE(
  dirName,
  sampleName = "sample01",
  coordNames = c("CenterX_global_px", "CenterY_global_px"),
  countMatFPattern = "exprMat_file.csv",
  metadataFPattern = "metadata_file.csv",
  polygonsFPattern = "polygons.csv",
  fovPosFPattern = "fov_positions_file.csv",
  fovdims = c(xdim = 4256, ydim = 4256),
  keepPolygons = FALSE
)
}
\arguments{
\item{dirName}{A character string specifying the directory containing the
CosMx data files.}

\item{sampleName}{A character string specifying the sample name. Default is
`"sample01"`.}

\item{coordNames}{A character vector specifying the names of the spatial
coordinate columns in the data. Default is `c("CenterX_global_px",
"CenterY_global_px")`.}

\item{countMatFPattern}{A character string specifying the pattern to match
the count matrix file. Default is `"exprMat_file.csv"`.}

\item{metadataFPattern}{A character string specifying the pattern to match
the metadata file. Default is `"metadata_file.csv"`.}

\item{polygonsFPattern}{A character string specifying the pattern to match
the polygons file. Default is `"polygons.csv"`.}

\item{fovPosFPattern}{A character string specifying the pattern to match the
FOV positions file. Default is `"fov_positions_file.csv"`.}

\item{fovdims}{A named numeric vector specifying the dimensions of the FOV
in pixels. Default is `c(xdim=4256, ydim=4256)`.}

\item{keepPolygons}{Logical indicating if the polygons need to be loaded into
memory or not (Default is `FALSE`).}
}
\value{
A `SpatialExperiment` object containing the read CosMx data,
including count matrices, metadata, and optionally polygons.
}
\description{
Read and Construct a SpatialExperiment Object from CosMx Data

This function reads in data from Nanostring CosMx files and constructs a
`SpatialExperiment` object, optionally including polygons data.
}
\details{
The function firstly relies on
\link[SpatialExperimentIO]{readCosmxSXE} to read in the specified files
for count matrices, metadata, and FOV positions constructing a
`SpatialExperiment` object.
Then it harmonizes the object to have the same metadata as for the other
technologies, setting the colData names as required in further QC analysis.

Optionally, polygons data can be read and added to the object by seeting
the `keepPolygons` argument to `TRUE`, otherwise it only stores the
polygons file path into the object metadata.


readCosmxProteinSPE is a wrapper of readCosmxSPE, it changes the
technology metadata in Nanostring_CosMx_Protein.
}
\examples{
cospath <- system.file(file.path("extdata", "CosMx_DBKero_Tiny"),
   package="SpaceTrooper")
spe <- readCosmxSPE(cospath, sampleName="DBKero_Tiny")
}
\author{
Dario Righelli, Benedetta Banzi
}
