% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spatialQCPlots.R
\name{plotPolygons}
\alias{plotPolygons}
\title{plotPolygons}
\usage{
plotPolygons(
  spe,
  colourBy = "darkgrey",
  colourLog = FALSE,
  polyColumn = "polygons.global",
  sampleId = unique(spe$sample_id),
  bgColor = "white",
  fillAlpha = 1,
  palette = NULL,
  borderCol = NA,
  borderAlpha = 1,
  borderLineWidth = 0.1,
  drawBorders = TRUE,
  scaleBar = TRUE,
  micronConvFact = 0.12
)
}
\arguments{
\item{spe}{A `SpatialExperiment` object with polygon data as an `sf` object.}

\item{colourBy}{A column in `colData(spe)` for coloring the polygons or a
string color in colors(). (Default is "darkgrey")}

\item{colourLog}{Logical to log-transform the data to enhance visualization
(Default is FALSE).}

\item{polyColumn}{character for the name of the column where the polygons sf
are stored (default is "polygons.global")}

\item{sampleId}{Sample ID for plot title. Default is the unique sample ID.}

\item{bgColor}{character indicating color for the background
(default is "white")}

\item{fillAlpha}{Transparency level for polygon fill. Default is `1`.}

\item{palette}{Colors to use if `colourBy` is a factor. Default is `NULL`.}

\item{borderCol}{Color of polygon borders. Default is `"black"`.}

\item{borderAlpha}{Transparency level for borders. Default is `1`.}

\item{borderLineWidth}{Width of polygon borders. Default is `0.1`.}

\item{drawBorders}{Logical; whether to draw borders. Default is `TRUE`.}

\item{scaleBar}{A logical value indicating whether to add a scale bar to the
plot. (Default is `TRUE`)}

\item{micronConvFact}{Numeric conversion factor from pixels to microns.
DEFAULT is `0.12`.}
}
\value{
A `ggplot` object representing the polygon plot of the spatial data.
}
\description{
Plot polygons from a `SpatialExperiment` object using ggplot2.
}
\details{
Renders polygon geometries stored in `colData` of a `SpatialExperiment`
object using `ggplot2::geom_sf()` and provides options for fill, borders
and an optional scale bar.

Input expectations:
- `spe` must be a `SpatialExperiment` and `polyColumn` must name a column
  in `colData(spe)` that contains polygon geometries (`sfc`/`sf` or a list
  of geometry objects) suitable for `geom_sf()`.
- `colourBy` supports two modes: (a) the name of a `colData` column to
  map fill to data values, or (b) a literal colour name (e.g. `"darkgrey"`)
  used as a constant fill.

Colour / palette behaviour:
- If `colourBy` refers to a `colData` column and `colourLog = TRUE`, the
  function computes `log1p()` of that column in the local plotting data
  frame (it does not mutate `spe`).
- `palette` may be a vector of colour values (used for discrete scales).
  Numeric `colourBy` values use a continuous Viridis-like scale by default.

Scale bar and units:
- If `scaleBar = TRUE` the function calls `.plotScaleBar()` to add a length
  scale. `micronConvFact` is the conversion factor (µm per pixel) used by
  `.plotScaleBar()` to label the bar in micrometres when appropriate.

Robustness notes:
- If `colourBy` is neither a `colData` column nor a valid colour name the
  function issues a warning and falls back to the default fill.
}
\examples{
example(readAndAddPolygonsToSPE)
plotPolygons(spe, colourBy="Mean.DAPI")
}
