% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spatialQCPlots.R
\name{plotCentroids}
\alias{plotCentroids}
\title{plotCentroids}
\usage{
plotCentroids(
  spe,
  colourBy = NULL,
  colourLog = FALSE,
  sampleId = unique(spe$sample_id),
  isNegativeProbe = FALSE,
  palette = NULL,
  pointCol = "darkmagenta",
  size = 0.05,
  alpha = 0.8,
  aspectRatio = 1,
  scaleBar = TRUE,
  micronConvFact = 0.12
)
}
\arguments{
\item{spe}{A `SpatialExperiment` object containing spatial
transcriptomics data.}

\item{colourBy}{An optional character string specifying the column in
`colData(spe)` to use for coloring the points. If `NULL`, all points will be
colored the same.}

\item{colourLog}{Logical to log-transform the data to enhance visualization
(Default is FALSE).}

\item{sampleId}{A character string specifying the sample identifier to be
used as the plot title. (Default is the unique sample ID from `spe`)}

\item{isNegativeProbe}{A logical value indicating whether to apply a custom
color gradient for negative probe data. (Default is `FALSE`)}

\item{palette}{A vector of colors to be used as a custom palette. For
categorical data, this should be a vector of colors with the same length as
the number of levels in `colourBy`. For continuous data, this should be a
vector of colors used to create a gradient.}

\item{pointCol}{A character string specifying the color of the points when
`colourBy` is `NULL`. (Default is `"darkmagenta"`)}

\item{size}{A numeric value specifying the size of the points. (Default is
`0.05`)}

\item{alpha}{A numeric value specifying the transparency level of the points.
(Default is `0.8`)}

\item{aspectRatio}{A numeric value specifying the aspect ratio of the plot.
(Default is `1`)}

\item{scaleBar}{A logical value indicating whether to add a scale bar to the
plot. (Default is `TRUE`)}

\item{micronConvFact}{Numeric conversion factor from pixels to microns.
DEFAULT is `0.12`.}
}
\value{
A `ggplot` object representing the spatial coordinates plot of
polygon centroids.
}
\description{
Plot Spatial Coordinates for a SpatialExperiment Object
This function generates a ggplot of spatial coordinates from a
`SpatialExperiment` object, optionally coloring the points by a specified
column in `colData`.
}
\details{
This function plots cell centroids from a `SpatialExperiment` object using
coordinates returned by `spatialCoords(spe)` and the coordinate names from
`spatialCoordsNames(spe)` (the function expects at least two spatial
coordinate dimensions). If `colourBy` is `NULL` all points are drawn using
`pointCol`; otherwise the function colors points using the specified
`colData` column or a provided palette.

Requirements and inputs:
- `spe` must be a `SpatialExperiment` with valid spatial coordinates.
- If `colourBy` is provided and is the name of a `colData` column, that
  column must exist and be suitable for plotting (factor/logical for
  discrete palettes, numeric for continuous palettes).
- `palette` may be either (a) a vector of color values (used directly) or
  (b) the name of a column in `colData(spe)` from which a palette will be
  built via `createPaletteFromColData()`. The function detects which mode
  to use at runtime.
}
\examples{
example(readCosmxSPE)
g <- plotCentroids(spe, colourBy="Mean.DAPI")
print(g)
}
