% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spatialQCPlots.R
\name{plotCellsFovs}
\alias{plotCellsFovs}
\title{plotCellsFovs}
\usage{
plotCellsFovs(
  spe,
  sampleId = unique(spe$sample_id),
  pointCol = "firebrick",
  numbersCol = "black",
  alphaNumbers = 0.8,
  fovDim = metadata(spe)$fov_dim,
  size = 0.05,
  alpha = 0.8,
  scaleBar = TRUE,
  micronConvFact = 0.12
)
}
\arguments{
\item{spe}{A `SpatialExperiment` object with `fov` in `colData`.}

\item{sampleId}{Character string identifying which sample to plot.
Default: `unique(spe$sample_id)`.}

\item{pointCol}{Color for the cell centroids. Default: `"firebrick"`.}

\item{numbersCol}{Color for the FoV labels. Default: `"black"`.}

\item{alphaNumbers}{Numeric transparency for FoV labels. Default: `0.8`.}

\item{fovDim}{numeric with two named dimensions xdim, ydim. (Default is
metadata(spe)$fov_dim)}

\item{size}{Numeric point size for the cell centroids. Default: `0.05`.}

\item{alpha}{Numeric transparency for the cell centroids. Default: `0.8`.}

\item{scaleBar}{A logical value indicating whether to add a scale bar to the
plot. (Default is `TRUE`)}

\item{micronConvFact}{Numeric conversion factor from pixels to microns.
Default is `0.12`.}
}
\value{
A `ggplot` object showing cell centroids and FoV boundaries.
}
\description{
Plot cell centroids in FoVs, creating a map of the whole experiment, where
cells are plotted as points and FoV boundaries and numbers are overlaid.
}
\details{
The function expects spe (a SpatialExperiment) to include field-of-view
metadata in metadata(spe):
- `metadata(spe)$fov_positions`: a matrix or data.frame
(or list with named elements) containing at minimum `x_global_px`, `y_global_px`,
and `fov`. Values `x_global_px`/`y_global_px` are in pixels and represent
the origin (top-left) of each FoV.
- `metadata(spe)$fov_dim` (or the `fovDim` argument): a named numeric with
`xdim` and `ydim` giving FoV width/height in pixels.

For each FoV the rectangle is drawn as:
- `xmin` = `x_global_px`,
- `xmax` = `x_global_px` + `xdim`,
- `ymin` = `y_global_px`,
- `ymax` = `y_global_px` + `ydim`.

`sampleId`: if `NULL` no plot title is added; if a vector of length > 1 is
provided the first element is used. Prefer passing a single sample identifier
string.
`micronConvFact` is the conversion factor from pixels to micrometers (µm/pixel).
It is forwarded to `.plotScaleBar()` and controls how the scale bar is labeled
(useful for technologies where coordinates are in pixels but the scale should
display µm).
The function uses the coordinates returned by `spatialCoords(spe)` and the
names from `spatialCoordsNames(spe)`. It performs basic input checks but
assumes the described metadata structures are present; if they are missing
or malformed the function will raise an informative error.
}
\examples{
example(readCosmxSPE)
g <- plotCellsFovs(spe)
print(g)
}
