% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/readXenium.R
\name{updateXeniumSPE}
\alias{updateXeniumSPE}
\title{updateXeniumSPE}
\usage{
updateXeniumSPE(
  spe,
  dirName,
  sampleName = "sample01",
  boundariesType = c("parquet", "csv"),
  computeMissingMetrics = TRUE,
  keepPolygons = FALSE,
  polygonsFPattern = "cell_boundaries",
  polygonsCol = "polygons",
  txPattern = "transcripts",
  addFOVs = FALSE
)
}
\arguments{
\item{spe}{SpatialExperiment object to update.}

\item{dirName}{Directory containing Xenium outputs.}

\item{sampleName}{Sample identifier to store (default \code{"sample01"}).}

\item{boundariesType}{One of \code{c("parquet","csv")} indicating the source
format of cell boundaries.}

\item{computeMissingMetrics}{Logical; if \code{TRUE}, compute metrics that are
not already present from transcripts/polygons.}

\item{keepPolygons}{Logical; if \code{TRUE}, keep polygons in the resulting
object (e.g., in metadata or colData, depending on implementation).}

\item{polygonsFPattern}{Character pattern used to locate polygon files when
boundaries are provided as CSVs (default \code{"polygons.csv"}).}

\item{polygonsCol}{Name of the geometry/column storing polygons when reading
from parquet (default \code{"polygons"}).}

\item{txPattern}{Pattern (file/glob) for transcript-level files
(default \code{"transcripts"}).}

\item{addFOVs}{Logical; if \code{TRUE}, derive and attach FOV identifiers
from transcript resources.}
}
\value{
Updated SpatialExperiment object.
}
\description{
Update a SpatialExperiment created from 10x Genomics Xenium outputs by
wiring polygons/boundaries, computing optional QC metrics, and standardizing
metadata and column names. This is a thin wrapper that delegates to the
internal helper `.setupXeniumSPE()`.
}
\details{
This function performs input checks and then calls `.setupXeniumSPE()`,
which does the heavy lifting (I/O, renaming, metadata updates, metrics).
}
\examples{
xepath <- system.file("extdata", "Xenium_small", package="SpaceTrooper")
(spe <- SpatialExperimentIO::readXeniumSXE(dirName=xepath))
spe <- updateXeniumSPE(spe, dirName=xepath, boundariesType="parquet",
    computeMissingMetrics=TRUE, keepPolygons=TRUE)
}
