% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spatialQCPlots.R
\name{plotCellsFovs}
\alias{plotCellsFovs}
\title{plotCellsFovs}
\usage{
plotCellsFovs(
  spe,
  sampleId = unique(spe$sample_id),
  pointCol = "firebrick",
  numbersCol = "black",
  alphaNumbers = 0.8,
  fovDim = metadata(spe)$fov_dim,
  size = 0.05,
  alpha = 0.8,
  scaleBar = TRUE,
  micronConvFact = 0.12
)
}
\arguments{
\item{spe}{A `SpatialExperiment` object with `fov` in `colData`.}

\item{sampleId}{Character string identifying which sample to plot.
Default: `unique(spe$sample_id)`.}

\item{pointCol}{Color for the cell centroids. Default: `"firebrick"`.}

\item{numbersCol}{Color for the FoV labels. Default: `"black"`.}

\item{alphaNumbers}{Numeric transparency for FoV labels. Default: `0.8`.}

\item{fovDim}{numeric with two named dimensions xdim, ydim. (Default is
metadata(spe)$fov_dim)}

\item{size}{Numeric point size for the cell centroids. Default: `0.05`.}

\item{alpha}{Numeric transparency for the cell centroids. Default: `0.8`.}

\item{scaleBar}{A logical value indicating whether to add a scale bar to the
plot. (Default is `TRUE`)}

\item{micronConvFact}{Numeric conversion factor from pixels to microns.
DEFAULT is `0.12`.}
}
\value{
A `ggplot` object showing cell centroids and FoV boundaries.
}
\description{
Plot cell centroids in FoVs
Creates a scatter plot with cell centroids arranged in their FoVs as an
overlapping grid.
}
\examples{
example(readCosmxSPE)
g <- plotCellsFovs(spe)
print(g)
}
