% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{getFencesOutlier}
\alias{getFencesOutlier}
\title{getFencesOutlier}
\usage{
getFencesOutlier(
  spe,
  fencesOf,
  highLow = c("both", "lower", "higher"),
  decimalRound = NULL
)
}
\arguments{
\item{spe}{A `SpatialExperiment` object containing spatial transcriptomics
data.}

\item{fencesOf}{A character string specifying the name of the column in
`colData(spe)` from which to extract the fence values. This column should
contain an `outlier.filter` object (see `computeSpatialOutlier```).}

\item{highLow}{character indicating which fence to get if "higher", "lower"
or "both" (default is "both").}

\item{decimalRound}{An optional integer specifying the number of decimal
places to which the fence values should be rounded. If `NULL`, no rounding is
 applied. Default is `NULL`.}
}
\value{
A numeric vector containing the lower and upper threshold values
extracted from the specified column.
}
\description{
Retrieve Threshold (Fence) Values from a SpatialExperiment Object

This function extracts the threshold values, also known as fences,
from a specified column in the `colData` of a `SpatialExperiment` object.
}
\examples{
example(computeSpatialOutlier)
getFencesOutlier(spe, fencesOf="log2SignalDensity_outlier_mc")
}
