% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/QC.R
\name{computeTrainDF}
\alias{computeTrainDF}
\title{computeTrainDF}
\usage{
computeTrainDF(colData, formulaVars, tech, verbose = FALSE)
}
\arguments{
\item{colData}{A per-cell metadata table. Typically
`as.data.frame(colData(spe))`. Must include at least:
`cell_id`, raw metric columns named in `formulaVars` (e.g.
`log2SignalDensity`, `Area_um`, `log2Ctrl_total_ratio`,
optionally `log2AspectRatio`), and the corresponding outlier-label
columns referenced by `formulaVars`.}

\item{formulaVars}{A named character vector mapping variable name to
its outlier label column name, e.g.
`c(log2SignalDensity="log2SignalDensity_outlier_train", ...)`.}

\item{tech}{Character string with the acquisition technology. Used to
enable CosMx-specific handling for `log2AspectRatio`. Expected
values include `"Nanostring_CosMx"` or `"Nanostring_CosMx_Protein"`.}

\item{verbose}{`logical(1)` (default \code{FALSE})
If \code{TRUE}, prints the number of “bad” and “good” cells selected.}
}
\value{
A \code{data.frame} with one row per cell, including:
  \code{qcscore_train} (0/1) indicating “bad” vs “good”,
  relevant \code{colData} columns used for modeling.
  Deduplicates and down-samples “good” cells to match the number of “bad” cells.
}
\description{
Build a Balanced Training Data Frame from a SpatialExperiment

\code{computeTrainDF} takes a \code{SpatialExperiment} object
and assembles a balanced training set of “good” vs “bad” cells for
subsequent model fitting.
}
\details{
The function builds a training set using the variables specified
in the `metadata` of the `SpatialExperiment` object.
}
\examples{
example(spatialPerCellQC)
spe <- computeOutliersQCScore(spe)
spe <- checkOutliers(spe)
df_train <- computeTrainDF(colData(spe), metadata(spe)$formula_variables,
    metadata(spe)$technology)
table(df_train$qcscore_train)

}
