% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/QC.R
\name{computeQCScore}
\alias{computeQCScore}
\title{computeQCScore}
\usage{
computeQCScore(spe, bestLambda = NULL, verbose = FALSE)
}
\arguments{
\item{spe}{A `SpatialExperiment` object with spatial transcriptomics data.}

\item{bestLambda}{the best lambda typically computed using `computeLambda`.}

\item{verbose}{logical for having a verbose output. Default is FALSE.}
}
\value{
The `SpatialExperiment` object with added QC score in `colData`.
}
\description{
Compute QC score and automatically define weights for QC score
through glm training. This function computes QC score with a formula
that is defined based on the metrics specified in metric_list and on the
number of available outliers for each metric.
}
\details{
For CosMx datasets, also CosMx Protein, the QC Score formula is
defined as follows:

QC score ~ count density - aspect ratio - control-total ratio

count density is total counts-to-area ratio, aspect ratio represents
FOV border effect typical of CosMx datasets and control-total ratio is
the aspecific signal. For each couple of variables interaction terms are
computed.

For Xenium and Merscope datasets, QC score cannot depend on aspect ratio
as no FOV border effect was captured through this metric.

Inclusion of metrics in the formula depends also on the number of available
outliers. If the number of outliers for each metric is < 0.1% out of the
entire dataset, the metric will be excluded from the QC score formula.

To automatically define the formula coefficient weights, model training
is performed through ridge regression.

Because of the randomness in the training set selection, results may vary so
that it is possible to set a fixed lambda value previously computed with
`computeLambda` preceeded by `computeTrainDF` and `getModelFormula`.
This is useful for reproducibility across different runs.
Otherwise, an easier way is to let be lambda computed internally, just set
a seed with `set.seed()` before running `computeQCScore`.
}
\examples{
example(spatialPerCellQC)
set.seed(1998)
spe <- computeQCScore(spe)
summary(spe$QC_score)
}
