% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spatialQCPlots.R
\name{plotQScoreTerms}
\alias{plotQScoreTerms}
\title{plotQScoreTerms}
\usage{
plotQScoreTerms(
  spe,
  sampleId = unique(spe$sample_id),
  size = 0.05,
  alpha = 0.8,
  aspectRatio = 1,
  custom = FALSE
)
}
\arguments{
\item{spe}{A `SpatialExperiment` object with `quality_score` and term
columns in `colData`.}

\item{sampleId}{Character string for plot title. Must match values in the
`fov` column of `colData(spe)`. Default: `unique(spe$sample_id)`.}

\item{size}{Numeric point size for the scatter plots. Default: `0.05`.}

\item{alpha}{Numeric transparency for the scatter plots. Default: `0.2`.}

\item{aspectRatio}{Numeric aspect ratio of the plots. Default: `1`.}

\item{custom}{Logical; if `TRUE`, use custom polygon‐derived metrics.}
}
\value{
A combined plot (via `cowplot::plot_grid`) showing spatial maps
  of each QS term.
}
\description{
Plots the individual terms that combine into the quality score formula,
allowing assessment of each term’s impact on the final score.
}
\examples{
example(readAndAddPolygonsToSPE)
example(spatialPerCellQC)
p <- plotQScoreTerms(spe)
print(p)
}
