% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/readCosMx.R
\name{.checkFovPositionVersion}
\alias{.checkFovPositionVersion}
\title{.checkFovPositionVersion}
\usage{
.checkFovPositionVersion(spe)
}
\arguments{
\item{spe}{A `SpatialExperiment` containing FOV position information
in the metadata to be standardized.}
}
\value{
A `SpatialExperiment` with updated and standardized column names
for the metadata `fov_position` `data.frame`.
}
\description{
Check and Standardize FOV Position Column Names

This internal utility function standardizes column names of a data frame
containing Field of View (FOV) positional information.
It modifies column names to ensure compatibility with expected naming
conventions, including support for older formats.

Specifically, it:
- Renames any column containing "FOV" to "fov"
- Converts columns with coordinates matching "X", "Y", or "Z" to lowercase
- Replaces suffix "_px" with "_global_px" for coordinate pixel columns
- If the input contains `x_mm` and `y_mm` columns, the function computes
corresponding `x_global_px` and `y_global_px` values by converting from
millimeters to pixels using a fixed resolution factor (0.12028 mm/pixel).
}
\keyword{internal}
