% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/basic_visualizations.R
\name{plotMissing}
\alias{plotMissing}
\title{Plot Missing Data Completeness}
\usage{
plotMissing(se)
}
\arguments{
\item{se}{A \code{SummarizedExperiment} object containing the assay data.}
}
\value{
A \code{ggplot2} object showing the percentage of completeness for
each sample.
}
\description{
\code{plotMissing} generates a bar plot showing the completeness (percentage
of non-missing values) for each sample in a \code{SummarizedExperiment}
object.
}
\details{
This function calculates the percentage of non-missing values for each sample
in the provided \code{SummarizedExperiment} object. It then generates a bar
plot where each bar represents a sample, and the height of the bar
corresponds to the completeness (percentage of non-missing values) of that
sample.
}
\examples{
library(SummarizedExperiment)
# Load multiAssayExperiment object
data("dda_example")
# Get SummarizedExperiment object
se <- dda_example[["Phosphoproteome"]]
colData(se) <- colData(dda_example)
# Call the function
plotMissing(se)

}
