% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/single_molecule_sorting.r
\name{StateQuantification}
\alias{StateQuantification}
\title{Convenience for calculating state frequencies}
\usage{
StateQuantification(SortedReads, states)
}
\arguments{
\item{SortedReads}{List of sorted reads (can be multiple samples) as returned by either read sorting function (SortReads, SortReadsBySingleTF, SortReadsByTFCluster)}

\item{states}{states reporting the biological interpretation of patterns as return by either SingleTFStates or TFPairStates functions. If NULL (default) will return frequencies without biological interpretation.}
}
\value{
tibble with state frequency information
}
\description{
Convenience for calculating state frequencies
}
\examples{

Methylation = qs::qread(system.file("extdata", "Methylation_4.qs", 
package="SingleMoleculeFootprinting"))
TFBSs = qs::qread(system.file("extdata", "TFBSs_1.qs", 
package="SingleMoleculeFootprinting"))
SortedReads = SortReadsByTFCluster(MethSM = Methylation[[2]], TFBS_cluster = TFBSs)
StateQuantification(SortedReads = SortedReads, states = TFPairStates())

}
