% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/single_molecule_sorting_gw_wrappers.r
\name{SortReadsByTFCluster_MultiSiteWrapper}
\alias{SortReadsByTFCluster_MultiSiteWrapper}
\title{Convenience wrapper to sort single molecule according to TFBS clusters at multiple sites in the genome}
\usage{
SortReadsByTFCluster_MultiSiteWrapper(
  sampleFile,
  samples,
  genome,
  coverage = 20,
  ConvRate.thr = 0.8,
  CytosinesToMask = NULL,
  TFBSs,
  max_intersite_distance = 75,
  min_intersite_distance = 15,
  max_cluster_size = 10,
  max_cluster_width = 300,
  add.single.TFs = TRUE,
  max_intercluster_distance = 1e+05,
  max_window_width = 5e+06,
  min_cluster_width = 600,
  fix.window.size = FALSE,
  max.window.size = NULL,
  sorting_coverage = 30,
  bins = list(c(-35, -25), c(-7, 7), c(25, 35)),
  cores = 1
)
}
\arguments{
\item{sampleFile}{QuasR pointer file}

\item{samples}{samples to use, from the SampleName field of the sampleFile}

\item{genome}{BSgenome}

\item{coverage}{coverage threshold as integer for least number of reads to cover a cytosine for it to be carried over in the analysis. Defaults to 20.}

\item{ConvRate.thr}{Convesion rate threshold. Double between 0 and 1, defaults to 0.8. To skip this filtering step, set to NULL. For more information, check out the details section.}

\item{CytosinesToMask}{CytosinesToMask object. Passed to MaskSNPs function}

\item{TFBSs}{GRanges object of transcription factor binding sites coordinates}

\item{max_intersite_distance}{maximum allowed distance in base pairs between two TFBS centers for them to be considered part of the same cluster. Defaults to 75.}

\item{min_intersite_distance}{minimum allowed distance in base pairs between two TFBS centers for them not to be discarded as overlapping. 
This parameter should be set according to the width of the bins used for later sorting. Defaults to 15.}

\item{max_cluster_size}{maximum number of TFBSs to be contained in any given cluster. Defaults to 10}

\item{max_cluster_width}{maximum cluster width in bp. Defaults to 300}

\item{add.single.TFs}{whether to add to output the TFBSs that didn't make it into clusters. Defaults to TRUE}

\item{max_intercluster_distance}{maximum distance between two consecutive TFBS clusters for them to be grouped in the same window}

\item{max_window_width}{upper limit to window width. This value should be adjusted according to the user's system as it determines the amount of memory used in the later context methylation call}

\item{min_cluster_width}{lower limit to window width. Corresponds to the scenario when a window contains a single TFBS cluster.}

\item{fix.window.size}{defaults to FALSE. Passed to Create_MethylationCallingWindows function.}

\item{max.window.size}{defaults to NULL. Passed to Create_MethylationCallingWindows function.}

\item{sorting_coverage}{integer. Minimum number of reads covering all sorting bins for sorting to be performed. Defaults to 30.}

\item{bins}{list of 3 relative bin coordinates. Defaults to list(c(-35,-25), c(-7,7), c(25,35)).
bins[[1]] represents the upstream bin, with coordinates relative to the start of the most upstream TFBS.
bins[[2]] represents all the TFBS bins, with coordinates relative to the center of each TFBS.
bins[[3]] represents the downstream bin, with coordinates relative to the end of the most downstream TFBS.}

\item{cores}{number of cores to use for parallel processing of multiple Methylation Calling Windows (i.e. groupings of adjecent TFBS clusters)}
}
\value{
list where [[1]] is the TFBS_Clusters object describing coordinates and composition of the TFBS clusters used to sort single molecules
                   [[2]] is a list of SortedReads nested per TFBS_cluster and sample
                   [[3]] is a tibble reporting the count (and frequency) of reads per state, samples and TFBS cluster
}
\description{
The function starts from a list of single TFBSs, arranges them into clusters, calls methylation at the interested sites and outputs sorted reads
}
\examples{

sampleFile = NULL
if(!is.null(sampleFile)){
SortReadsByTFCluster_MultiSiteWrapper(
sampleFile = sampleFile, 
samples = samples, 
genome = BSgenome.Mmusculus.UCSC.mm10, 
coverage = 20, ConvRate.thr = NULL, 
CytosinesToMask = NULL,
TFBSs = KLF4s, 
max_interTF_distance = NULL, max_window_width = NULL, min_cluster_width = NULL, 
fix.window.size = TRUE, max.window.size = 50, 
cores = 4
) -> sorting_results
}

}
