% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting.r
\name{PlotSM}
\alias{PlotSM}
\title{Wrapper for PlotSingleMoleculeStack function}
\usage{
PlotSM(
  MethSM,
  RegionOfInterest,
  sorting.strategy = "classical",
  SortedReads = NULL
)
}
\arguments{
\item{MethSM}{Single molecule methylation matrix}

\item{RegionOfInterest}{GRanges interval to plot}

\item{sorting.strategy}{One of "classical" (default), "custom", "hierarchical.clustering" or "None".
Set to "classical" for classical one-TF/TF-pair sorting (as described in Sönmezer et al, MolCell, 2021). Should be passed along with argument SortedReads set to the Sorted reads object as returned by SortReads function.
If set to "custom", SortedReads should be a list with one item per sample (corresponding to MethSM).
If set to "hierarchical.clustering", the function will perform hierarchical clustering in place on a subset of reads. Useful to check for duplicated reads in amplicon sequencing experiments.
If set to "None", it will plot unsorted reads.
The argument sorting,strategy will always determine how to display reads with priority over the argument SortedReads}

\item{SortedReads}{Defaults to NULL, in which case will plot unsorted reads. Sorted reads object as returned by SortReads function}
}
\description{
adds the convenience of arranging reads before plotting
}
\examples{

library(GenomicRanges)

RegionOfInterest = GRanges("chr12", IRanges(20464551, 20465050))
Methylation = qs::qread(system.file("extdata", "Methylation_3.qs", 
package="SingleMoleculeFootprinting"))
TFBSs = qs::qread(system.file("extdata", "TFBSs_3.qs", 
package="SingleMoleculeFootprinting"))
SortedReads = SortReadsBySingleTF(MethSM = Methylation[[2]], TFBS = TFBSs)

PlotSM(MethSM = Methylation[[2]], RegionOfInterest = RegionOfInterest, SortedReads = SortedReads)

}
