% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methylation_calling_utils.r
\name{Create_MethylationCallingWindows}
\alias{Create_MethylationCallingWindows}
\title{Create methylation calling windows to call context methylation in one run for clusters lying proximally to each other}
\usage{
Create_MethylationCallingWindows(
  RegionsOfInterest,
  max_intercluster_distance = 1e+05,
  max_window_width = 5e+06,
  min_cluster_width = 600,
  genomic.seqlenghts,
  fix.window.size = FALSE,
  max.window.size = 500
)
}
\arguments{
\item{RegionsOfInterest}{TFBS cluster coordinates analogous to ClusterCoordinates object returned by Arrange_TFBSs_clusters function}

\item{max_intercluster_distance}{maximum distance between two consecutive TFBS clusters for them to be grouped in the same window}

\item{max_window_width}{upper limit to window width. This value should be adjusted according to the user's system as it determines the amount of memory used in the later context methylation call}

\item{min_cluster_width}{lower limit to window width. Corresponds to the scenario when a window contains a single TFBS cluster.}

\item{genomic.seqlenghts}{used to fix the windows spanning over chromosome edges. To be fetched by Seqinfo::seqlengths() or equivalent.}

\item{fix.window.size}{Defaults to FALSE. When TRUE, overrides arguments max_intercluster_distance and max_window_width and produces windows containing a fixed number of TFBS_clusters.}

\item{max.window.size}{Max number of TFBS_clusters per window. Used only when fix.window.size is TRUE. N.b.: window size could be slightly higher than passed value if RegionsOfInterest overlap}
}
\value{
GRanges object of window coordinates to be used for more efficient calls of CallContextMethylation
}
\description{
Relevant for genome-wide analyses
}
\examples{

KLF4s = qs::qread(system.file("extdata", "KLF4_chr19.qs", package="SingleMoleculeFootprinting"))
Create_MethylationCallingWindows(RegionsOfInterest = KLF4s)

}
