% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/composite_plotting.r
\name{CollectCompositeData}
\alias{CollectCompositeData}
\title{Collect bulk SMF data for later composite plotting}
\usage{
CollectCompositeData(
  sampleFile,
  samples,
  genome,
  TFBSs,
  window,
  coverage = 20,
  ConvRate.thr = NULL,
  cores = 1
)
}
\arguments{
\item{sampleFile}{QuasR sampleFile}

\item{samples}{vector of unique sample names corresponding to the SampleName field from the sampleFile}

\item{genome}{BSgenome}

\item{TFBSs}{GRanges object of TF binding sites to collect info for. We reccommend employing 50 to 200 TFBSs.}

\item{window}{window size to collect methylation information for}

\item{coverage}{coverage threshold as integer for least number of reads to cover a cytosine for it to be carried over in the analysis. Defaults to 20.}

\item{ConvRate.thr}{Convesion rate threshold. Double between 0 and 1, defaults to NULL For more information, check out the details section}

\item{cores}{number of cores to use}
}
\value{
data.frame of bulk SMF info ready for plotting
}
\description{
Collect bulk SMF data for later composite plotting
}
\examples{

sampleFile = NULL
if(!is.null(sampleFile)){
CollectCompositeData(
sampleFile = sampleFile, 
samples = samples, 
genome = BSgenome.Mmusculus.UCSC.mm10, 
TFBSs = TopMotifs, 
window = 1000, 
coverage = 20, 
ConvRate.thr = NULL, 
cores = 16
) -> CompositeData
}

}
